"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTabs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _entity_details_flyout = require("../../../entity_analytics/components/entity_details_flyout");
var _model = require("../../../explore/users/store/model");
var _managed_details = require("../../../../common/search_strategy/security_solution/users/managed_details");
var _test_ids = require("./test_ids");
var _asset_document = require("./tabs/asset_document");
var _context = require("../../document_details/shared/context");
var _types = require("../../../../common/entity_analytics/types");
var _left_panel_header = require("../shared/components/left_panel/left_panel_header");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTabs = (managedUser, name, isRiskScoreExist, scopeId, hasMisconfigurationFindings, hasNonClosedAlerts) => (0, _react.useMemo)(() => {
  const tabs = [];
  const entraManagedUser = managedUser[_managed_details.ManagedUserDatasetKey.ENTRA];
  const oktaManagedUser = managedUser[_managed_details.ManagedUserDatasetKey.OKTA];
  if (isRiskScoreExist) {
    tabs.push((0, _entity_details_flyout.getRiskInputTab)({
      entityName: name,
      entityType: _types.EntityType.user,
      scopeId
    }));
  }
  if (oktaManagedUser) {
    tabs.push(getOktaTab(oktaManagedUser));
  }
  if (entraManagedUser) {
    tabs.push(getEntraTab(entraManagedUser));
  }
  if (hasMisconfigurationFindings || hasNonClosedAlerts) {
    tabs.push((0, _entity_details_flyout.getInsightsInputTab)({
      name,
      fieldName: _types.EntityIdentifierFields.userName
    }));
  }
  return tabs;
}, [hasMisconfigurationFindings, hasNonClosedAlerts, isRiskScoreExist, managedUser, name, scopeId]);
exports.useTabs = useTabs;
const getOktaTab = oktaManagedUser => ({
  id: _left_panel_header.EntityDetailsLeftPanelTab.OKTA,
  'data-test-subj': _test_ids.OKTA_TAB_TEST_ID,
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.userDetails.okta.tabLabel",
    defaultMessage: "Okta Data"
  }),
  content: /*#__PURE__*/_react.default.createElement(_context.DocumentDetailsProvider, {
    id: oktaManagedUser._id,
    indexName: oktaManagedUser._index,
    scopeId: _model.UserAssetTableType.assetOkta
  }, /*#__PURE__*/_react.default.createElement(_asset_document.AssetDocumentTab, null))
});
const getEntraTab = entraManagedUser => {
  return {
    id: _left_panel_header.EntityDetailsLeftPanelTab.ENTRA,
    'data-test-subj': _test_ids.ENTRA_TAB_TEST_ID,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.userDetails.entra.tabLabel",
      defaultMessage: "Entra Data"
    }),
    content: /*#__PURE__*/_react.default.createElement(_context.DocumentDetailsProvider, {
      id: entraManagedUser._id,
      indexName: entraManagedUser._index,
      scopeId: _model.UserAssetTableType.assetEntra
    }, /*#__PURE__*/_react.default.createElement(_asset_document.AssetDocumentTab, null))
  };
};