"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrevalenceOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../../../common/lib/kibana");
var _expandable_panel = require("../../../shared/components/expandable_panel");
var _use_prevalence = require("../../shared/hooks/use_prevalence");
var _test_ids = require("./test_ids");
var _context = require("../../shared/context");
var _left = require("../../left");
var _prevalence_details = require("../../left/components/prevalence_details");
var _insights_summary_row = require("./insights_summary_row");
var _use_navigate_to_left_panel = require("../../shared/hooks/use_navigate_to_left_panel");
var _local_storage = require("../../shared/constants/local_storage");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UNCOMMON = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.flyout.right.insights.prevalence.uncommonLabel",
  defaultMessage: "Uncommon"
});
const DEFAULT_TIME_RANGE_LABEL = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.flyout.right.insights.threatIntelligence.defaultTimeRangeApplied.badgeLabel",
  defaultMessage: "Time range applied"
});
const CUSTOM_TIME_RANGE_LABEL = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.flyout.right.insights.threatIntelligence.customTimeRangeApplied.badgeLabel",
  defaultMessage: "Custom time range applied"
});
const DEFAULT_TIME_RANGE_TOOLTIP = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.flyout.right.insights.threatIntelligence.defaultTimeRangeApplied.tooltipLabel",
  defaultMessage: "Prevalence measures how frequently data from this alert is observed across hosts or users in your environment over the last 30 days. To choose a custom time range, click the section title, then use the date time picker in the left panel."
});
const CUSTOM_TIME_RANGE_TOOLTIP = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.flyout.right.insights.threatIntelligence.customTimeRangeApplied.tooltipLabel",
  defaultMessage: "Prevalence measures how frequently data from this alert is observed across hosts or users in your environment over the time range that you chose. To choose a different custom time range, click the section title, then use the date time picker in the left panel."
});
const PERCENTAGE_THRESHOLD = 0.1; // we show the prevalence if its value is below 10%
const DEFAULT_FROM = 'now-30d';
const DEFAULT_TO = 'now';

/**
 * Prevalence section under Insights section, overview tab.
 * The component fetches the necessary data at once. The loading and error states are handled by the ExpandablePanel component.
 */
const PrevalenceOverview = () => {
  const {
    storage
  } = (0, _kibana.useKibana)().services;
  const timeSavedInLocalStorage = storage.get(_local_storage.FLYOUT_STORAGE_KEYS.PREVALENCE_TIME_RANGE);
  const {
    dataFormattedForFieldBrowser,
    investigationFields,
    isPreviewMode
  } = (0, _context.useDocumentDetailsContext)();
  const {
    navigateToLeftPanel: goToPrevalenceTab,
    isEnabled: isLinkEnabled
  } = (0, _use_navigate_to_left_panel.useNavigateToLeftPanel)({
    tab: _left.LeftPanelInsightsTab,
    subTab: _prevalence_details.PREVALENCE_TAB_ID
  });
  const {
    loading,
    error,
    data
  } = (0, _use_prevalence.usePrevalence)({
    dataFormattedForFieldBrowser,
    investigationFields,
    interval: {
      from: (timeSavedInLocalStorage === null || timeSavedInLocalStorage === void 0 ? void 0 : timeSavedInLocalStorage.start) || DEFAULT_FROM,
      to: (timeSavedInLocalStorage === null || timeSavedInLocalStorage === void 0 ? void 0 : timeSavedInLocalStorage.end) || DEFAULT_TO
    }
  });

  // only show data if the host prevalence is below 10%
  const uncommonData = (0, _react.useMemo)(() => data.filter(d => isFinite(d.hostPrevalence) && d.hostPrevalence > 0 && d.hostPrevalence < PERCENTAGE_THRESHOLD), [data]);
  const link = (0, _react.useMemo)(() => isLinkEnabled ? {
    callback: goToPrevalenceTab,
    tooltip: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.insights.prevalence.prevalenceTooltip",
      defaultMessage: "Show all prevalence"
    })
  } : undefined, [goToPrevalenceTab, isLinkEnabled]);
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.insights.prevalence.prevalenceTitle",
        defaultMessage: "Prevalence"
      }),
      link,
      iconType: !isPreviewMode ? 'arrowStart' : undefined,
      headerContent: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: timeSavedInLocalStorage ? CUSTOM_TIME_RANGE_TOOLTIP : DEFAULT_TIME_RANGE_TOOLTIP
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        iconSide: "left",
        iconType: "clock",
        tabIndex: 0
      }, timeSavedInLocalStorage ? CUSTOM_TIME_RANGE_LABEL : DEFAULT_TIME_RANGE_LABEL))
    },
    content: {
      loading,
      error
    },
    "data-test-subj": _test_ids.PREVALENCE_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, uncommonData.length > 0 ? uncommonData.map(d => /*#__PURE__*/_react.default.createElement(_insights_summary_row.InsightsSummaryRow, {
    text: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, d.field, ',', " ", d.values.toString()),
    value: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "warning"
    }, UNCOMMON),
    "data-test-subj": `${_test_ids.PREVALENCE_TEST_ID}${d.field}`,
    key: `${_test_ids.PREVALENCE_TEST_ID}${d.field}`
  })) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.insights.prevalence.noDataDescription",
    defaultMessage: "No prevalence data available."
  })));
};
exports.PrevalenceOverview = PrevalenceOverview;
PrevalenceOverview.displayName = 'PrevalenceOverview';