"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingPrivilegesCallout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _line_clamp = require("../../../../common/components/line_clamp");
var _privileges = require("../../../../../common/entity_analytics/privileges");
var _comma_separated_values = require("../../../../detections/components/callouts/missing_privileges_callout/comma_separated_values");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The height of the callout when the content is clamped.
 * The value was chosen based on trial and error.
 */
const LINE_CLAMP_HEIGHT = '4.4em';
const MissingPrivilegesCallout = exports.MissingPrivilegesCallout = /*#__PURE__*/_react.default.memo(({
  privileges
}) => {
  var _missingPrivileges$el, _missingPrivileges$el2;
  const missingPrivileges = (0, _privileges.getAllMissingPrivileges)(privileges);
  const indexPrivileges = (_missingPrivileges$el = missingPrivileges.elasticsearch.index) !== null && _missingPrivileges$el !== void 0 ? _missingPrivileges$el : {};
  const clusterPrivileges = (_missingPrivileges$el2 = missingPrivileges.elasticsearch.cluster) !== null && _missingPrivileges$el2 !== void 0 ? _missingPrivileges$el2 : {};
  const featurePrivileges = missingPrivileges.kibana;
  const id = `missing-entity-store-privileges`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.title",
      defaultMessage: "Insufficient privileges to enable the Entity Store"
    }),
    iconType: 'info',
    "data-test-subj": `callout-${id}`,
    "data-test-messages": `[${id}]`
  }, /*#__PURE__*/_react.default.createElement(_line_clamp.LineClamp, {
    maxHeight: "100%",
    lineClampHeight: LINE_CLAMP_HEIGHT
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, indexPrivileges.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.messageBody.indexPrivilegesTitle",
    defaultMessage: "Missing Elasticsearch index privileges:"
  }), /*#__PURE__*/_react.default.createElement("ul", null, indexPrivileges.map(({
    indexName,
    privileges: privilege
  }) => /*#__PURE__*/_react.default.createElement("li", {
    key: indexName
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.messageBody.missingIndexPrivileges",
    defaultMessage: "Missing {privileges} privileges for the {index} index.",
    values: {
      privileges: /*#__PURE__*/_react.default.createElement(_comma_separated_values.CommaSeparatedValues, {
        values: privilege
      }),
      index: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, indexName)
    }
  }))))) : null, clusterPrivileges.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.messageBody.clusterPrivilegesTitle",
    defaultMessage: "Missing Elasticsearch cluster privileges:"
  }), /*#__PURE__*/_react.default.createElement("ul", null, clusterPrivileges.map(privilege => /*#__PURE__*/_react.default.createElement("li", {
    key: privilege
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, privilege))))) : null, featurePrivileges.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.messageBody.featurePrivilegesTitle",
    defaultMessage: "Missing Kibana feature privileges:"
  }), /*#__PURE__*/_react.default.createElement("ul", null, featurePrivileges.map(feature => /*#__PURE__*/_react.default.createElement("li", {
    key: feature
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.messageBody.missingFeaturePrivileges",
    defaultMessage: "Missing privilege for the {feature} feature.",
    values: {
      feature: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, feature)
    }
  }))))) : null)));
});
MissingPrivilegesCallout.displayName = 'MissingPrivilegesCallout';