"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutdatedMlJobsUpgradeModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _polished = require("polished");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JobsUL = _styledComponents.default.ul`
  max-height: 200px;
  overflow-y: auto;

  &::-webkit-scrollbar {
    height: ${({
  theme
}) => theme.eui.euiScrollBar};
    width: ${({
  theme
}) => theme.eui.euiScrollBar};
  }

  &::-webkit-scrollbar-thumb {
    background-clip: content-box;
    background-color: ${({
  theme
}) => (0, _polished.rgba)(theme.eui.euiColorDarkShade, 0.5)};
    border: ${({
  theme
}) => theme.eui.euiScrollBarCorner} solid transparent;
  }

  &::-webkit-scrollbar-corner,
  &::-webkit-scrollbar-track {
    background-color: transparent;
  }
`;
const OutdatedMlJobsUpgradeModal = exports.OutdatedMlJobsUpgradeModal = /*#__PURE__*/(0, _react.memo)(function LegacyMlJobsUpgradeModal({
  jobs,
  onCancel,
  onConfirm
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: i18n.ML_JOB_UPGRADE_MODAL_TITLE,
    onCancel: onCancel,
    onConfirm: onConfirm,
    cancelButtonText: i18n.ML_JOB_UPGRADE_MODAL_CANCEL,
    confirmButtonText: i18n.ML_JOB_UPGRADE_MODAL_CONFIRM,
    buttonColor: "danger",
    defaultFocusedButton: "confirm"
  }, /*#__PURE__*/_react.default.createElement(i18n.MlJobUpgradeModalBody, null), i18n.ML_JOB_UPGRADE_MODAL_AFFECTED_JOBS, /*#__PURE__*/_react.default.createElement(JobsUL, null, jobs.map(j => {
    return /*#__PURE__*/_react.default.createElement("li", {
      key: j.id
    }, j.id);
  })));
});