"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuleFields = void 0;
var _use_rule_indices = require("./use_rule_indices");
var _source = require("../../../common/containers/source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRuleFields = ({
  machineLearningJobId,
  indexPattern
}) => {
  const {
    ruleIndices
  } = (0, _use_rule_indices.useRuleIndices)(machineLearningJobId, indexPattern);
  const [loading, {
    indexPatterns: {
      fields
    }
  }] = (0, _source.useFetchIndex)(ruleIndices);
  return {
    loading,
    fields
  };
};
exports.useRuleFields = useRuleFields;