"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeverityMappingEdit = SeverityMappingEdit;
exports.severityMappingDeserializer = severityMappingDeserializer;
exports.severityMappingSerializer = severityMappingSerializer;
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../../../../../shared_imports");
var _severity_override = require("../../../../../../rule_creation_ui/components/severity_mapping/severity_override");
var _use_default_index_pattern = require("../../../../../hooks/use_default_index_pattern");
var _utils = require("../utils");
var _form = require("../../../../../../rule_creation_ui/pages/form");
var _helpers = require("../../../../../../common/helpers");
var _helpers2 = require("../../../../../../rule_creation_ui/pages/rule_creation/helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SeverityMappingEdit({
  finalDiffableRule
}) {
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "severityMapping",
    component: SeverityMappingField,
    componentProps: {
      finalDiffableRule
    }
  });
}
function SeverityMappingField({
  field,
  finalDiffableRule
}) {
  const defaultIndexPattern = (0, _use_default_index_pattern.useDefaultIndexPattern)();
  const indexPatternParameters = (0, _utils.getUseRuleIndexPatternParameters)(finalDiffableRule, defaultIndexPattern);
  const {
    indexPattern,
    isIndexPatternLoading
  } = (0, _form.useRuleIndexPattern)(indexPatternParameters);
  const {
    value,
    setValue
  } = field;
  const handleFieldChange = (0, _react.useCallback)((index, severity, [newField]) => {
    setValue(prevValue => {
      var _newField$name;
      const newMappingItem = [{
        ...prevValue.mapping[index],
        field: (_newField$name = newField === null || newField === void 0 ? void 0 : newField.name) !== null && _newField$name !== void 0 ? _newField$name : '',
        value: newField != null ? prevValue.mapping[index].value : '',
        operator: 'equals',
        severity
      }];
      return {
        ...prevValue,
        mapping: [...prevValue.mapping.slice(0, index), ...newMappingItem, ...prevValue.mapping.slice(index + 1)]
      };
    });
  }, [setValue]);
  const handleFieldMatchValueChange = (0, _react.useCallback)((index, severity, newMatchValue) => {
    setValue(prevValue => {
      const newMappingItem = [{
        ...prevValue.mapping[index],
        field: prevValue.mapping[index].field,
        value: prevValue.mapping[index].field != null && prevValue.mapping[index].field !== '' ? newMatchValue : '',
        operator: 'equals',
        severity
      }];
      return {
        ...prevValue,
        mapping: [...prevValue.mapping.slice(0, index), ...newMappingItem, ...prevValue.mapping.slice(index + 1)]
      };
    });
  }, [setValue]);
  const handleSeverityMappingChecked = (0, _react.useCallback)(() => {
    setValue(prevValue => ({
      ...prevValue,
      isMappingChecked: !prevValue.isMappingChecked
    }));
  }, [setValue]);
  return /*#__PURE__*/_react.default.createElement(_severity_override.SeverityOverride, {
    isDisabled: isIndexPatternLoading,
    onSeverityMappingChecked: handleSeverityMappingChecked,
    onFieldChange: handleFieldChange,
    onFieldMatchValueChange: handleFieldMatchValueChange,
    isMappingChecked: value.isMappingChecked,
    mapping: value.mapping,
    indices: indexPattern
  });
}
function severityMappingDeserializer(defaultValue) {
  return {
    severityMapping: {
      isMappingChecked: defaultValue.severity_mapping.length > 0,
      mapping: (0, _helpers.fillEmptySeverityMappings)(defaultValue.severity_mapping)
    }
  };
}
function severityMappingSerializer(formData) {
  return {
    severity_mapping: formData.severityMapping.isMappingChecked ? (0, _helpers2.filterOutEmptySeverityMappingItems)(formData.severityMapping.mapping) : []
  };
}