"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toggleRiskSummaryClickedEvent = exports.entityTelemetryEvents = exports.entityStoreInitEvent = exports.entityStoreEnablementEvent = exports.entityRiskFilteredEvent = exports.entityClickedEvent = exports.entityAlertsClickedEvent = exports.assetCriticalityFileSelectedEvent = exports.assetCriticalityCsvPreviewGeneratedEvent = exports.assetCriticalityCsvImportedEvent = exports.addRiskInputToTimelineClickedEvent = exports.RiskInputsExpandedFlyoutOpenedEvent = void 0;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const entityClickedEvent = exports.entityClickedEvent = {
  eventType: _types.EntityEventTypes.EntityDetailsClicked,
  schema: {
    entity: {
      type: 'keyword',
      _meta: {
        description: 'Entity name (host|user)',
        optional: false
      }
    }
  }
};
const entityAlertsClickedEvent = exports.entityAlertsClickedEvent = {
  eventType: _types.EntityEventTypes.EntityAlertsClicked,
  schema: {
    entity: {
      type: 'keyword',
      _meta: {
        description: 'Entity name (host|user)',
        optional: false
      }
    }
  }
};
const entityRiskFilteredEvent = exports.entityRiskFilteredEvent = {
  eventType: _types.EntityEventTypes.EntityRiskFiltered,
  schema: {
    entity: {
      type: 'keyword',
      _meta: {
        description: 'Entity name (host|user)',
        optional: true
      }
    },
    selectedSeverity: {
      type: 'keyword',
      _meta: {
        description: 'Selected severity (Unknown|Low|Moderate|High|Critical)',
        optional: false
      }
    }
  }
};
const toggleRiskSummaryClickedEvent = exports.toggleRiskSummaryClickedEvent = {
  eventType: _types.EntityEventTypes.ToggleRiskSummaryClicked,
  schema: {
    entity: {
      type: 'keyword',
      _meta: {
        description: 'Entity name (host|user)',
        optional: false
      }
    },
    action: {
      type: 'keyword',
      _meta: {
        description: 'It defines if the section is opening or closing (show|hide)',
        optional: false
      }
    }
  }
};
const RiskInputsExpandedFlyoutOpenedEvent = exports.RiskInputsExpandedFlyoutOpenedEvent = {
  eventType: _types.EntityEventTypes.RiskInputsExpandedFlyoutOpened,
  schema: {
    entity: {
      type: 'keyword',
      _meta: {
        description: 'Entity name (host|user)',
        optional: false
      }
    }
  }
};
const addRiskInputToTimelineClickedEvent = exports.addRiskInputToTimelineClickedEvent = {
  eventType: _types.EntityEventTypes.AddRiskInputToTimelineClicked,
  schema: {
    quantity: {
      type: 'integer',
      _meta: {
        description: 'Quantity of alerts added to timeline',
        optional: false
      }
    }
  }
};
const assetCriticalityFileSelectedEvent = exports.assetCriticalityFileSelectedEvent = {
  eventType: _types.EntityEventTypes.AssetCriticalityFileSelected,
  schema: {
    valid: {
      type: 'boolean',
      _meta: {
        description: 'If the file is valid',
        optional: false
      }
    },
    errorCode: {
      type: 'keyword',
      _meta: {
        description: 'Error code if the file is invalid',
        optional: true
      }
    },
    file: {
      properties: {
        size: {
          type: 'long',
          _meta: {
            description: 'File size in bytes',
            optional: false
          }
        }
      }
    }
  }
};
const assetCriticalityCsvPreviewGeneratedEvent = exports.assetCriticalityCsvPreviewGeneratedEvent = {
  eventType: _types.EntityEventTypes.AssetCriticalityCsvPreviewGenerated,
  schema: {
    file: {
      properties: {
        size: {
          type: 'long',
          _meta: {
            description: 'File size in bytes',
            optional: false
          }
        }
      }
    },
    processing: {
      properties: {
        startTime: {
          type: 'date',
          _meta: {
            description: 'Processing start time',
            optional: false
          }
        },
        endTime: {
          type: 'date',
          _meta: {
            description: 'Processing end time',
            optional: false
          }
        },
        tookMs: {
          type: 'long',
          _meta: {
            description: 'Processing time in milliseconds',
            optional: false
          }
        }
      }
    },
    stats: {
      properties: {
        validLines: {
          type: 'long',
          _meta: {
            description: 'Number of valid lines',
            optional: false
          }
        },
        invalidLines: {
          type: 'long',
          _meta: {
            description: 'Number of invalid lines',
            optional: false
          }
        },
        totalLines: {
          type: 'long',
          _meta: {
            description: 'Total number of lines',
            optional: false
          }
        }
      }
    }
  }
};
const assetCriticalityCsvImportedEvent = exports.assetCriticalityCsvImportedEvent = {
  eventType: _types.EntityEventTypes.AssetCriticalityCsvImported,
  schema: {
    file: {
      properties: {
        size: {
          type: 'long',
          _meta: {
            description: 'File size in bytes',
            optional: false
          }
        }
      }
    }
  }
};
const entityStoreInitEvent = exports.entityStoreInitEvent = {
  eventType: _types.EntityEventTypes.EntityStoreDashboardInitButtonClicked,
  schema: {
    timestamp: {
      type: 'date',
      _meta: {
        description: 'Timestamp of the event',
        optional: false
      }
    }
  }
};
const entityStoreEnablementEvent = exports.entityStoreEnablementEvent = {
  eventType: _types.EntityEventTypes.EntityStoreEnablementToggleClicked,
  schema: {
    timestamp: {
      type: 'date',
      _meta: {
        description: 'Timestamp of the event',
        optional: false
      }
    },
    action: {
      type: 'keyword',
      _meta: {
        description: 'Event toggle action',
        optional: false
      }
    }
  }
};
const mlJobUpdateEvent = {
  eventType: _types.EntityEventTypes.MLJobUpdate,
  schema: {
    jobId: {
      type: 'keyword',
      _meta: {
        description: 'Job id',
        optional: false
      }
    },
    isElasticJob: {
      type: 'boolean',
      _meta: {
        description: 'If true the job is one of the pre-configure security solution modules',
        optional: false
      }
    },
    moduleId: {
      type: 'keyword',
      _meta: {
        description: 'Module id',
        optional: true
      }
    },
    status: {
      type: 'keyword',
      _meta: {
        description: 'It describes what has changed in the job.',
        optional: false
      }
    },
    errorMessage: {
      type: 'text',
      _meta: {
        description: 'Error message',
        optional: true
      }
    }
  }
};
const anomaliesCountClickedEvent = {
  eventType: _types.EntityEventTypes.AnomaliesCountClicked,
  schema: {
    jobId: {
      type: 'keyword',
      _meta: {
        description: 'Job id',
        optional: false
      }
    },
    count: {
      type: 'integer',
      _meta: {
        description: 'Number of anomalies',
        optional: false
      }
    }
  }
};
const entityTelemetryEvents = exports.entityTelemetryEvents = [entityClickedEvent, entityAlertsClickedEvent, entityRiskFilteredEvent, assetCriticalityCsvPreviewGeneratedEvent, assetCriticalityFileSelectedEvent, assetCriticalityCsvImportedEvent, entityStoreEnablementEvent, entityStoreInitEvent, toggleRiskSummaryClickedEvent, RiskInputsExpandedFlyoutOpenedEvent, addRiskInputToTimelineClickedEvent, mlJobUpdateEvent, anomaliesCountClickedEvent];