"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleBootstrapResults = exports.RuleBootstrapError = exports.PackageInstallStatus = exports.BootstrapPrebuiltRulesResponse = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Bootstrap Prebuilt Rules API endpoint
 *   version: 1
 */

const PackageInstallStatus = exports.PackageInstallStatus = _zod.z.object({
  /**
   * The name of the package
   */
  name: _zod.z.string(),
  /**
   * The version of the package
   */
  version: _zod.z.string(),
  /**
   * The status of the package installation
   */
  status: _zod.z.enum(['installed', 'already_installed'])
});
const RuleBootstrapError = exports.RuleBootstrapError = _zod.z.object({
  /**
   * The list of rules that failed to bootstrap
   */
  rules: _zod.z.array(_zod.z.object({
    /**
     * The ID of the rule that failed to bootstrap
     */
    rule_id: _zod.z.string()
  })),
  /**
   * The error message
   */
  message: _zod.z.string()
});
const RuleBootstrapResults = exports.RuleBootstrapResults = _zod.z.object({
  /**
   * The total number of rules to be processed. This is a dynamic value and depends on the number of integrations installed that have bootstrappable rules
   */
  total: _zod.z.number().optional(),
  /**
   * The number of rules that were installed
   */
  installed: _zod.z.number(),
  /**
   * The number of rules that were updated
   */
  updated: _zod.z.number(),
  /**
   * The number of rules that were deleted
   */
  deleted: _zod.z.number(),
  /**
   * The number of rules that were skipped (already installed rules with no updates)
   */
  skipped: _zod.z.number().optional(),
  /**
   * The list of bootstrap errors
   */
  errors: _zod.z.array(RuleBootstrapError)
});
const BootstrapPrebuiltRulesResponse = exports.BootstrapPrebuiltRulesResponse = _zod.z.object({
  /**
   * The list of packages that were installed or upgraded
   */
  packages: _zod.z.array(PackageInstallStatus),
  /**
   * The list of rules that were installed or upgraded
   */
  rules: RuleBootstrapResults.optional()
});