"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePageMode = void 0;
var _react = require("react");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePageMode = ({
  hasSelectedIndices,
  hasConnectors,
  initialPageMode = _types.PlaygroundPageMode.chat
}) => {
  const [showSetupPage, setShowSetupPage] = (0, _react.useState)(true);
  const [pageMode, setPageMode] = (0, _react.useState)(initialPageMode);
  (0, _react.useEffect)(() => {
    if (pageMode === _types.PlaygroundPageMode.chat) {
      if (showSetupPage && hasConnectors && hasSelectedIndices) {
        setShowSetupPage(false);
      } else if (!showSetupPage && (!hasConnectors || !hasSelectedIndices)) {
        setShowSetupPage(true);
      }
    } else {
      if (showSetupPage && hasSelectedIndices) {
        setShowSetupPage(false);
      } else if (!showSetupPage && !hasSelectedIndices) {
        setShowSetupPage(true);
      }
    }
  }, [hasSelectedIndices, showSetupPage, pageMode, hasConnectors]);
  return {
    showSetupPage,
    pageMode,
    setPageMode
  };
};
exports.usePageMode = usePageMode;