"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLLMsModels = void 0;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _inferenceEndpointUiCommon = require("@kbn/inference-endpoint-ui-common");
var _types = require("../../common/types");
var _use_load_connectors = require("./use_load_connectors");
var _models = require("../../common/models");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isInferenceActionConnector = connector => {
  return 'config' in connector && 'provider' in connector.config;
};
const mapLlmToModels = {
  [_types.LLMs.openai]: {
    icon: _inferenceEndpointUiCommon.SERVICE_PROVIDERS.openai.icon,
    getModels: (connectorName, includeName) => _models.MODELS.filter(({
      provider
    }) => provider === _types.LLMs.openai).map(model => ({
      label: `${model.name} ${includeName ? `(${connectorName})` : ''}`,
      value: model.model,
      promptTokenLimit: model.promptTokenLimit
    }))
  },
  [_types.LLMs.openai_azure]: {
    icon: _inferenceEndpointUiCommon.SERVICE_PROVIDERS.openai.icon,
    getModels: connectorName => [{
      label: _i18n.i18n.translate('xpack.searchPlayground.openAIAzureModel', {
        defaultMessage: '{name} (Azure OpenAI)',
        values: {
          name: connectorName
        }
      })
    }]
  },
  [_types.LLMs.openai_other]: {
    icon: _inferenceEndpointUiCommon.SERVICE_PROVIDERS.openai.icon,
    getModels: connectorName => [{
      label: _i18n.i18n.translate('xpack.searchPlayground.otherOpenAIModel', {
        defaultMessage: '{name} (OpenAI Compatible Service)',
        values: {
          name: connectorName
        }
      })
    }]
  },
  [_types.LLMs.bedrock]: {
    icon: _inferenceEndpointUiCommon.SERVICE_PROVIDERS.amazonbedrock.icon,
    getModels: () => _models.MODELS.filter(({
      provider
    }) => provider === _types.LLMs.bedrock).map(model => ({
      label: model.name,
      value: model.model,
      promptTokenLimit: model.promptTokenLimit
    }))
  },
  [_types.LLMs.gemini]: {
    icon: _inferenceEndpointUiCommon.SERVICE_PROVIDERS.googlevertexai.icon,
    getModels: () => _models.MODELS.filter(({
      provider
    }) => provider === _types.LLMs.gemini).map(model => ({
      label: model.name,
      value: model.model,
      promptTokenLimit: model.promptTokenLimit
    }))
  },
  [_types.LLMs.inference]: {
    icon: connector => {
      return isInferenceActionConnector(connector) ? _inferenceEndpointUiCommon.SERVICE_PROVIDERS[connector.config.provider].icon : '';
    },
    getModels: (connectorName, _, modelId) => {
      var _MODELS$find;
      return [{
        label: connectorName,
        value: modelId,
        promptTokenLimit: (_MODELS$find = _models.MODELS.find(m => m.model === modelId)) === null || _MODELS$find === void 0 ? void 0 : _MODELS$find.promptTokenLimit
      }];
    }
  }
};
const useLLMsModels = () => {
  const {
    data: connectors
  } = (0, _use_load_connectors.useLoadConnectors)();
  const mapConnectorTypeToCount = (0, _react.useMemo)(() => connectors === null || connectors === void 0 ? void 0 : connectors.reduce((result, connector) => ({
    ...result,
    [connector.type]: (result[connector.type] || 0) + 1
  }), {}), [connectors]);
  return (0, _react.useMemo)(() => (connectors === null || connectors === void 0 ? void 0 : connectors.reduce((result, connector) => {
    var _connector$config, _connector$config$pro;
    const connectorType = connector.type;
    const llmParams = mapLlmToModels[connectorType];
    if (!llmParams) {
      return result;
    }
    const showConnectorName = Number(mapConnectorTypeToCount === null || mapConnectorTypeToCount === void 0 ? void 0 : mapConnectorTypeToCount[connectorType]) > 1;
    return [...result, ...llmParams.getModels(connector.name, false, isInferenceActionConnector(connector) ? (_connector$config = connector.config) === null || _connector$config === void 0 ? void 0 : (_connector$config$pro = _connector$config.providerConfig) === null || _connector$config$pro === void 0 ? void 0 : _connector$config$pro.model_id : undefined).map(({
      label,
      value,
      promptTokenLimit
    }) => ({
      id: (connector === null || connector === void 0 ? void 0 : connector.id) + label,
      name: label,
      value,
      connectorType: connector.type,
      connectorName: connector.name,
      showConnectorName,
      icon: typeof llmParams.icon === 'function' ? llmParams.icon(connector) : llmParams.icon,
      disabled: !connector,
      connectorId: connector.id,
      promptTokenLimit
    }))];
  }, [])) || [], [connectors, mapConnectorTypeToCount]);
};
exports.useLLMsModels = useLLMsModels;