"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DevToolsCode = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _types = require("../../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DevToolsCode = () => {
  var _getValues, _getValues2, _getValues3;
  const {
    getValues
  } = (0, _reactHookForm.useFormContext)();
  const query = (_getValues = getValues(_types.ChatFormFields.elasticsearchQuery)) !== null && _getValues !== void 0 ? _getValues : '';
  const indices = (_getValues2 = getValues(_types.ChatFormFields.indices)) !== null && _getValues2 !== void 0 ? _getValues2 : [];
  const searchQuery = (_getValues3 = getValues(_types.ChatFormFields.searchQuery)) !== null && _getValues3 !== void 0 ? _getValues3 : '';
  const replacedQuery = searchQuery ? JSON.stringify(query, null, 2).replace(/\"{query}\"/g, JSON.stringify(searchQuery)) : JSON.stringify(query, null, 2);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    overflowHeight: "100%"
  }, `POST ${indices.join(',')}/_search
${replacedQuery}
`);
};
exports.DevToolsCode = DevToolsCode;