"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.jobLoadError = exports.isUpdating = exports.isSortAscending = exports.isSaving = exports.isLoading = exports.isDetailPanelOpen = exports.getTotalItems = exports.getTableState = exports.getSortField = exports.getPager = exports.getPageOfJobs = exports.getJobsList = exports.getJobs = exports.getJobStatusByJobName = exports.getJobByJobId = exports.getHasPreviousPage = exports.getHasNextPage = exports.getFilteredIds = exports.getFilter = exports.getDetailPanelType = exports.getDetailPanelJobId = exports.getDetailPanelJob = exports.getCurrentPage = exports.getCreateJobError = exports.getCloneJobConfig = void 0;
var _eui = require("@elastic/eui");
var _reselect = require("reselect");
var _services = require("../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getJobs = state => state.jobs.byId;
exports.getJobs = getJobs;
const getJobsList = state => state.jobs.allIds;
exports.getJobsList = getJobsList;
const getJobByJobId = (state, id) => getJobs(state)[id];
exports.getJobByJobId = getJobByJobId;
const getFilteredIds = state => state.jobs.filteredIds;
exports.getFilteredIds = getFilteredIds;
const getTableState = state => state.tableState;
exports.getTableState = getTableState;
const getDetailPanelType = state => state.detailPanel.panelType;
exports.getDetailPanelType = getDetailPanelType;
const isDetailPanelOpen = state => state.detailPanel.isOpen;
exports.isDetailPanelOpen = isDetailPanelOpen;
const getDetailPanelJob = state => getJobByJobId(state, state.detailPanel.jobId);
exports.getDetailPanelJob = getDetailPanelJob;
const getDetailPanelJobId = state => state.detailPanel.jobId;
exports.getDetailPanelJobId = getDetailPanelJobId;
const isLoading = state => state.jobs.isLoading;
exports.isLoading = isLoading;
const jobLoadError = state => state.jobs.jobLoadError;
exports.jobLoadError = jobLoadError;
const isSaving = state => state.createJob.isSaving;
exports.isSaving = isSaving;
const getCreateJobError = state => state.createJob.error;
exports.getCreateJobError = getCreateJobError;
const isUpdating = state => state.updateJob.isUpdating;
exports.isUpdating = isUpdating;
const getCloneJobConfig = state => state.cloneJob.job;
exports.getCloneJobConfig = getCloneJobConfig;
const getJobStatusByJobName = (state, jobName) => {
  const jobs = getJobs(state);
  const {
    status
  } = jobs[jobName] || {};
  return status;
};
exports.getJobStatusByJobName = getJobStatusByJobName;
const getFilteredJobs = (0, _reselect.createSelector)(getJobs, getTableState, (jobs, tableState) => {
  const jobArray = Object.keys(jobs).map(jobName => jobs[jobName]);
  return (0, _services.filterItems)(['id', 'indexPattern', 'rollupIndex'], tableState.filter, jobArray);
});
const getTotalItems = exports.getTotalItems = (0, _reselect.createSelector)(getFilteredJobs, filteredJobs => {
  return Object.keys(filteredJobs).length;
});
const getPager = exports.getPager = (0, _reselect.createSelector)(getTableState, getTotalItems, ({
  currentPage,
  pageSize
}, totalItems) => {
  return new _eui.Pager(totalItems, pageSize, currentPage);
});
const getPageOfJobs = exports.getPageOfJobs = (0, _reselect.createSelector)(getFilteredJobs, getTableState, getPager, (filteredJobs, tableState, pager) => {
  const sortedIndexes = (0, _services.sortTable)(filteredJobs, tableState.sortField, tableState.isSortAscending);
  const {
    firstItemIndex,
    lastItemIndex
  } = pager;
  const pagedIndexes = sortedIndexes.slice(firstItemIndex, lastItemIndex + 1);
  return pagedIndexes;
});
const getHasNextPage = exports.getHasNextPage = (0, _reselect.createSelector)(getPager, pager => {
  return pager.hasNextPage;
});
const getHasPreviousPage = exports.getHasPreviousPage = (0, _reselect.createSelector)(getPager, pager => {
  return pager.hasPreviousPage;
});
const getCurrentPage = exports.getCurrentPage = (0, _reselect.createSelector)(getPager, pager => {
  return pager.currentPage;
});
const getFilter = exports.getFilter = (0, _reselect.createSelector)(getTableState, ({
  filter
}) => filter);
const isSortAscending = exports.isSortAscending = (0, _reselect.createSelector)(getTableState, ({
  isSortAscending
}) => isSortAscending);
const getSortField = exports.getSortField = (0, _reselect.createSelector)(getTableState, ({
  sortField
}) => sortField);