"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerJobInfoRoutesPublic = registerJobInfoRoutesPublic;
var _reportingCommon = require("@kbn/reporting-common");
var _server = require("@kbn/security-plugin/server");
var _common = require("../common");
var _jobs = require("../common/jobs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerJobInfoRoutesPublic(reporting) {
  const setupDeps = reporting.getPluginSetupDeps();
  const {
    router
  } = setupDeps;

  // use common route handlers that are shared for public and internal routes
  const jobHandlers = (0, _jobs.commonJobsRouteHandlerFactory)(reporting, {
    isInternal: false
  });
  const registerPublicDownloadReport = () => {
    // trigger a download of the output from a job
    const path = _reportingCommon.PUBLIC_ROUTES.JOBS.DOWNLOAD_PREFIX + '/{docId}';
    router.get({
      path,
      security: {
        authz: {
          enabled: false,
          reason: 'This route is opted out from authorization'
        }
      },
      validate: jobHandlers.validate,
      options: {
        tags: [_server.ROUTE_TAG_CAN_REDIRECT],
        access: 'public'
      }
    }, (0, _common.authorizedUserPreRouting)(reporting, async (user, context, req, res) => {
      return jobHandlers.handleDownloadReport({
        path,
        user,
        context,
        req,
        res
      });
    }));
  };
  const registerPublicDeleteReport = () => {
    // allow a report to be deleted
    const path = _reportingCommon.PUBLIC_ROUTES.JOBS.DELETE_PREFIX + '/{docId}';
    router.delete({
      path,
      security: {
        authz: {
          enabled: false,
          reason: 'This route is opted out from authorization'
        }
      },
      validate: jobHandlers.validate,
      options: {
        access: 'public'
      }
    }, (0, _common.authorizedUserPreRouting)(reporting, async (user, context, req, res) => {
      return jobHandlers.handleDeleteReport({
        path,
        user,
        context,
        req,
        res
      });
    }));
  };
  registerPublicDownloadReport();
  registerPublicDeleteReport();
}