"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KbnCategoricalPalette = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _palette = require("./palette");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class KbnCategoricalPalette extends _palette.KbnBasePalette {
  constructor({
    colors,
    colorCount = colors.length,
    ...rest
  }) {
    super({
      ...rest,
      colorCount
    });
    (0, _defineProperty2.default)(this, "type", 'categorical');
    (0, _defineProperty2.default)(this, "_colors", void 0);
    (0, _defineProperty2.default)(this, "colors", n => {
      const end = n === undefined ? n : Math.max(1, n);
      return this._colors.slice(0, end);
    });
    this._colors = colors;
  }
}
exports.KbnCategoricalPalette = KbnCategoricalPalette;