"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generatePath = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generatePath = ({
  step,
  path
}) => {
  const stepIndex = path.findIndex(key => key === step);
  if (stepIndex !== -1) {
    return path.slice(0, stepIndex + 1);
  }
  return [...path, step];
};
exports.generatePath = generatePath;