"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePopulatedAWSIndexList = usePopulatedAWSIndexList;
var _use_fetcher = require("../../../hooks/use_fetcher");
var _aws_firehose = require("../../../../common/aws_firehose");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function usePopulatedAWSIndexList() {
  return (0, _use_fetcher.useFetcher)(callApi => {
    return callApi('GET /internal/observability_onboarding/firehose/has-data', {
      params: {
        query: {
          streamName: _aws_firehose.FIREHOSE_STREAM_NAME,
          stackName: _aws_firehose.FIREHOSE_CLOUDFORMATION_STACK_NAME
        }
      }
    });
  }, []);
}