"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverLinkForValidState = exports.DiscoverLinkForUnknownState = exports.DiscoverLink = exports.ConnectedDiscoverLink = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/logs-explorer-plugin/common");
var _public = require("@kbn/logs-explorer-plugin/public");
var _routerUtils = require("@kbn/router-utils");
var _react = require("@xstate/react");
var _react2 = _interopRequireWildcard(require("react"));
var _translations = require("../../common/translations");
var _src = require("../state_machines/observability_logs_explorer/src");
var _use_kibana = require("../utils/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectedDiscoverLink = exports.ConnectedDiscoverLink = /*#__PURE__*/_react2.default.memo(() => {
  const {
    services: {
      discover
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [pageState] = (0, _react.useActor)((0, _src.useObservabilityLogsExplorerPageStateContext)());
  if (pageState.matches({
    initialized: 'validLogsExplorerState'
  })) {
    return /*#__PURE__*/_react2.default.createElement(DiscoverLinkForValidState, {
      discover: discover,
      pageState: pageState
    });
  } else {
    return /*#__PURE__*/_react2.default.createElement(DiscoverLinkForUnknownState, null);
  }
});
const DiscoverLinkForValidState = exports.DiscoverLinkForValidState = /*#__PURE__*/_react2.default.memo(({
  discover,
  pageState: {
    context: {
      logsExplorerState,
      allSelection
    }
  }
}) => {
  const discoverLinkParams = (0, _react2.useMemo)(() => {
    var _logsExplorerState$ch;
    const index = (0, _common.hydrateDataSourceSelection)(logsExplorerState.dataSourceSelection, allSelection).toDataviewSpec();
    return {
      breakdownField: (_logsExplorerState$ch = logsExplorerState.chart.breakdownField) !== null && _logsExplorerState$ch !== void 0 ? _logsExplorerState$ch : undefined,
      columns: (0, _public.getDiscoverColumnsWithFallbackFieldsFromDisplayOptions)(logsExplorerState),
      filters: (0, _public.getDiscoverFiltersFromState)(index.id, logsExplorerState.filters, logsExplorerState.controls),
      query: logsExplorerState.query,
      refreshInterval: logsExplorerState.refreshInterval,
      timeRange: logsExplorerState.time,
      dataViewSpec: index
    };
  }, [allSelection, logsExplorerState]);
  return /*#__PURE__*/_react2.default.createElement(DiscoverLink, {
    discover: discover,
    discoverLinkParams: discoverLinkParams
  });
});
const DiscoverLinkForUnknownState = exports.DiscoverLinkForUnknownState = /*#__PURE__*/_react2.default.memo(() => /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderLink, {
  color: "primary",
  iconType: "discoverApp",
  "data-test-subj": "logsExplorerDiscoverFallbackLink",
  disabled: true
}, _translations.discoverLinkTitle));
const DiscoverLink = exports.DiscoverLink = /*#__PURE__*/_react2.default.memo(({
  discover,
  discoverLinkParams
}) => {
  var _discover$locator;
  const discoverUrl = (_discover$locator = discover.locator) === null || _discover$locator === void 0 ? void 0 : _discover$locator.getRedirectUrl(discoverLinkParams);
  const navigateToDiscover = () => {
    var _discover$locator2;
    (_discover$locator2 = discover.locator) === null || _discover$locator2 === void 0 ? void 0 : _discover$locator2.navigate(discoverLinkParams);
  };
  const discoverLinkProps = (0, _routerUtils.getRouterLinkProps)({
    href: discoverUrl,
    onClick: navigateToDiscover
  });
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiHeaderLink, (0, _extends2.default)({}, discoverLinkProps, {
    color: "primary",
    iconType: "discoverApp",
    "data-test-subj": "logsExplorerDiscoverFallbackLink"
  }), _translations.discoverLinkTitle);
});