"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleDatasetLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/logs-explorer-plugin/common");
var _locators = require("@kbn/deeplinks-observability/locators");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SingleDatasetLocatorDefinition {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "id", _locators.SINGLE_DATASET_LOCATOR_ID);
    (0, _defineProperty2.default)(this, "getLocation", params => {
      const {
        useHash
      } = this.deps;
      const {
        integration,
        dataset
      } = params;
      const unresolvedDatasetSelection = _common.UnresolvedDatasetSelection.fromSelection({
        name: integration,
        dataset: {
          name: this.composeIndexPattern(dataset)
        }
      });
      return (0, _utils.constructLocatorPath)({
        dataSourceSelection: unresolvedDatasetSelection.toPlainSelection(),
        locatorParams: params,
        useHash
      });
    });
    this.deps = deps;
  }
  composeIndexPattern(datasetName) {
    return `logs-${datasetName}-*`;
  }
}
exports.SingleDatasetLocatorDefinition = SingleDatasetLocatorDefinition;