"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCpuUsageAlertType = createCpuUsageAlertType;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../common/constants");
var _lazy_expression = require("../components/param_details_form/lazy_expression");
var _validation = require("../components/param_details_form/validation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createCpuUsageAlertType(config) {
  return {
    id: _constants.RULE_CPU_USAGE,
    description: _constants.RULE_DETAILS[_constants.RULE_CPU_USAGE].description,
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return `${docLinks.links.monitoring.alertsKibanaCpuThreshold}`;
    },
    ruleParamsExpression: props => /*#__PURE__*/_react.default.createElement(_lazy_expression.LazyExpression, (0, _extends2.default)({}, props, {
      config: config,
      paramDetails: _constants.RULE_DETAILS[_constants.RULE_CPU_USAGE].paramDetails
    })),
    validate: _validation.validate,
    defaultActionMessage: '{{context.internalFullMessage}}',
    requiresAppContext: _constants.RULE_REQUIRES_APP_CONTEXT
  };
}