"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initComponent = void 0;
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _common = require("@kbn/field-formats-plugin/common");
var _i18nReact = require("@kbn/i18n-react");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _cases = require("../../common/constants/cases");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initComponent = exports.initComponent = (0, _lodash.memoize)(fieldFormats => {
  return /*#__PURE__*/_react.default.memo(props => {
    var _inputProps$query, _inputProps$query2;
    const {
      persistableStateAttachmentState,
      caseData
    } = props;
    const dataFormatter = fieldFormats.deserialize({
      id: _common.FIELD_FORMAT_IDS.DATE
    });
    const inputProps = persistableStateAttachmentState;
    const listItems = [{
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.cases.anomalySwimLane.description.jobIdsLabel",
        defaultMessage: "Job IDs"
      }),
      description: inputProps.jobIds.join(', ')
    }, ...(inputProps.viewBy ? [{
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.cases.anomalySwimLane.description.viewByLabel",
        defaultMessage: "View by"
      }),
      description: inputProps.viewBy
    }] : []), {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.cases.anomalySwimLane.description.timeRangeLabel",
        defaultMessage: "Time range"
      }),
      description: `${dataFormatter.convert(inputProps.timeRange.from)} - ${dataFormatter.convert(inputProps.timeRange.to)}`
    }];
    if (typeof ((_inputProps$query = inputProps.query) === null || _inputProps$query === void 0 ? void 0 : _inputProps$query.query) === 'string' && ((_inputProps$query2 = inputProps.query) === null || _inputProps$query2 === void 0 ? void 0 : _inputProps$query2.query) !== '') {
      var _inputProps$query3;
      listItems.push({
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.cases.anomalySwimLane.description.queryLabel",
          defaultMessage: "Query"
        }),
        description: (_inputProps$query3 = inputProps.query) === null || _inputProps$query3 === void 0 ? void 0 : _inputProps$query3.query
      });
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      compressed: true,
      type: 'inline',
      listItems: listItems
    }), /*#__PURE__*/_react.default.createElement(_public.EmbeddableRenderer, {
      maybeId: inputProps.id,
      type: _cases.CASE_ATTACHMENT_TYPE_ID_ANOMALY_SWIMLANE,
      getParentApi: () => ({
        getSerializedStateForChild: () => ({
          rawState: inputProps
        }),
        executionContext: {
          type: 'cases',
          description: caseData.title,
          id: caseData.id
        }
      })
    }));
  }, (prevProps, nextProps) => (0, _fastDeepEqual.default)(prevProps.persistableStateAttachmentState, nextProps.persistableStateAttachmentState));
});