"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeseriesexplorerNoJobsFound = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _kibana = require("../../../contexts/kibana");
var _locator = require("../../../../../common/constants/locator");
var _check_capabilities = require("../../../capabilities/check_capabilities");
var _ml_nodes_check = require("../../../ml_nodes_check");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React component for rendering EuiEmptyPrompt when no jobs were found.
 */

const TimeseriesexplorerNoJobsFound = () => {
  const jobLink = (0, _kibana.useMlLink)({
    page: _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB
  });
  const canCreateJob = (0, _check_capabilities.usePermissionCheck)('canCreateJob');
  const disableCreateAnomalyDetectionJob = !canCreateJob || !(0, _ml_nodes_check.mlNodesAvailable)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "mlNoSingleMetricJobsFound",
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.timeSeriesExplorer.noSingleMetricJobsFoundLabel",
      defaultMessage: "No single metric jobs found"
    })),
    actions:
    /*#__PURE__*/
    // @ts-ignore disabled type expects undefined
    _react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      href: jobLink,
      disabled: disableCreateAnomalyDetectionJob
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.timeSeriesExplorer.createNewSingleMetricJobLinkText",
      defaultMessage: "Create new single metric job"
    }))
  });
};
exports.TimeseriesexplorerNoJobsFound = TimeseriesexplorerNoJobsFound;