"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewCalendar = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = require("prop-types");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _utils = require("./utils");
var _calendar_form = require("./calendar_form");
var _new_event_modal = require("./new_event_modal");
var _import_modal = require("./import_modal");
var _public = require("@kbn/kibana-react-plugin/public");
var _calendars = require("../../../../../common/constants/calendars");
var _locator = require("../../../../../common/constants/locator");
var _toast_notification_service = require("../../../services/toast_notification_service");
var _help_menu = require("../../../components/help_menu");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class NewCalendarUI extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "returnToCalendarsManagementPage", async () => {
      const {
        services: {
          http: {
            basePath
          },
          application: {
            navigateToUrl
          }
        }
      } = this.props.kibana;
      await navigateToUrl(`${basePath.get()}/app/ml/${this.props.isDst ? _locator.ML_PAGES.CALENDARS_DST_MANAGE : _locator.ML_PAGES.CALENDARS_MANAGE}`, true);
    });
    (0, _defineProperty2.default)(this, "isDuplicateId", () => {
      const {
        calendars,
        formCalendarId
      } = this.state;
      for (let i = 0; i < calendars.length; i++) {
        if (calendars[i].calendar_id === formCalendarId) {
          return true;
        }
      }
      return false;
    });
    (0, _defineProperty2.default)(this, "onCreate", async () => {
      const mlApi = this.props.kibana.services.mlServices.mlApi;
      const {
        formCalendarId
      } = this.state;
      if (this.isDuplicateId()) {
        const {
          toasts
        } = this.props.kibana.services.notifications;
        toasts.addDanger(_i18n.i18n.translate('xpack.ml.calendarsEdit.canNotCreateCalendarWithExistingIdErrorMessag', {
          defaultMessage: 'Cannot create calendar with id [{formCalendarId}] as it already exists.',
          values: {
            formCalendarId
          }
        }));
      } else {
        const calendar = this.setUpCalendarForApi();
        this.setState({
          saving: true
        });
        try {
          await mlApi.addCalendar(calendar);
          await this.returnToCalendarsManagementPage();
        } catch (error) {
          this.setState({
            saving: false
          });
          this.toastNotificationService.displayErrorToast(error, _i18n.i18n.translate('xpack.ml.calendarsEdit.errorWithCreatingCalendarErrorMessage', {
            defaultMessage: 'An error occurred creating calendar {calendarId}',
            values: {
              calendarId: calendar.calendarId
            }
          }));
        }
      }
    });
    (0, _defineProperty2.default)(this, "onEdit", async () => {
      const mlApi = this.props.kibana.services.mlServices.mlApi;
      const calendar = this.setUpCalendarForApi();
      this.setState({
        saving: true
      });
      try {
        await mlApi.updateCalendar(calendar);
        await this.returnToCalendarsManagementPage();
      } catch (error) {
        this.setState({
          saving: false
        });
        this.toastNotificationService.displayErrorToast(error, _i18n.i18n.translate('xpack.ml.calendarsEdit.errorWithUpdatingCalendarErrorMessage', {
          defaultMessage: 'An error occurred saving calendar {calendarId}. Try refreshing the page.',
          values: {
            calendarId: calendar.calendarId
          }
        }));
      }
    });
    (0, _defineProperty2.default)(this, "setUpCalendarForApi", () => {
      const {
        formCalendarId,
        description,
        events,
        selectedGroupOptions,
        selectedJobOptions,
        isGlobalCalendar
      } = this.state;
      const allIds = isGlobalCalendar ? [_calendars.GLOBAL_CALENDAR] : [...selectedJobOptions.map(option => option.label), ...selectedGroupOptions.map(option => option.label)];

      // Reduce events to fields expected by api
      const eventsToSave = events.map(event => ({
        description: event.description,
        start_time: event.start_time,
        end_time: event.end_time,
        ...(event.skip_result !== undefined ? {
          skip_result: event.skip_result
        } : {}),
        ...(event.skip_model_update !== undefined ? {
          skip_model_update: event.skip_model_update
        } : {}),
        ...(event.force_time_shift !== undefined ? {
          force_time_shift: event.force_time_shift
        } : {})
      }));

      // set up calendar
      const calendar = {
        calendarId: formCalendarId,
        description,
        events: eventsToSave,
        job_ids: allIds
      };
      return calendar;
    });
    (0, _defineProperty2.default)(this, "onCreateGroupOption", newGroup => {
      const newOption = {
        label: newGroup
      };
      // Select the option.
      this.setState(prevState => ({
        selectedGroupOptions: prevState.selectedGroupOptions.concat(newOption)
      }));
    });
    (0, _defineProperty2.default)(this, "onGlobalCalendarChange", ({
      currentTarget
    }) => {
      this.setState({
        isGlobalCalendar: currentTarget.checked
      });
    });
    (0, _defineProperty2.default)(this, "onJobSelection", selectedJobOptions => {
      this.setState({
        selectedJobOptions
      });
    });
    (0, _defineProperty2.default)(this, "onGroupSelection", selectedGroupOptions => {
      this.setState({
        selectedGroupOptions
      });
    });
    (0, _defineProperty2.default)(this, "onCalendarIdChange", e => {
      const isValid = (0, _utils.validateCalendarId)(e.target.value);
      this.setState({
        formCalendarId: e.target.value,
        isNewCalendarIdValid: isValid
      });
    });
    (0, _defineProperty2.default)(this, "onDescriptionChange", e => {
      this.setState({
        description: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "showImportModal", () => {
      this.setState(prevState => ({
        isImportModalVisible: !prevState.isImportModalVisible
      }));
    });
    (0, _defineProperty2.default)(this, "closeImportModal", () => {
      this.setState({
        isImportModalVisible: false
      });
    });
    (0, _defineProperty2.default)(this, "onEventDelete", eventId => {
      this.setState(prevState => ({
        events: prevState.events.filter(event => event.event_id !== eventId)
      }));
    });
    (0, _defineProperty2.default)(this, "closeNewEventModal", () => {
      this.setState({
        isNewEventModalVisible: false
      });
    });
    (0, _defineProperty2.default)(this, "showNewEventModal", () => {
      this.setState({
        isNewEventModalVisible: true
      });
    });
    (0, _defineProperty2.default)(this, "addEvent", event => {
      this.setState(prevState => ({
        events: [...prevState.events, event],
        isNewEventModalVisible: false
      }));
    });
    (0, _defineProperty2.default)(this, "addEvents", events => {
      this.setState(prevState => ({
        events: [...prevState.events, ...events],
        isNewEventModalVisible: false
      }));
    });
    (0, _defineProperty2.default)(this, "clearEvents", () => {
      this.setState(() => ({
        events: []
      }));
    });
    (0, _defineProperty2.default)(this, "addImportedEvents", events => {
      this.setState(prevState => ({
        events: [...prevState.events, ...events],
        isImportModalVisible: false
      }));
    });
    this.state = {
      isNewEventModalVisible: false,
      isImportModalVisible: false,
      isNewCalendarIdValid: null,
      loading: true,
      jobIds: [],
      jobIdOptions: [],
      groupIds: [],
      groupIdOptions: [],
      calendars: [],
      formCalendarId: '',
      description: '',
      selectedJobOptions: [],
      selectedGroupOptions: [],
      events: [],
      saving: false,
      selectedCalendar: undefined,
      isGlobalCalendar: false
    };
  }
  componentDidMount() {
    this.toastNotificationService = (0, _toast_notification_service.toastNotificationServiceProvider)(this.props.kibana.services.notifications.toasts);
    this.formSetup();
  }
  async formSetup() {
    try {
      const {
        jobIds,
        groupIds,
        calendars
      } = await (0, _utils.getCalendarSettingsData)(this.props.kibana.services.mlServices.mlApi);
      const jobIdOptions = jobIds.map(jobId => ({
        label: jobId
      }));
      const groupIdOptions = groupIds.map(groupId => ({
        label: groupId
      }));
      const selectedJobOptions = [];
      const selectedGroupOptions = [];
      let eventsList = [];
      let selectedCalendar;
      let formCalendarId = '';
      let isGlobalCalendar = false;

      // Editing existing calendar.
      if (this.props.calendarId !== undefined) {
        selectedCalendar = calendars.find(cal => cal.calendar_id === this.props.calendarId);
        if (selectedCalendar) {
          formCalendarId = selectedCalendar.calendar_id;
          eventsList = selectedCalendar.events;
          if (selectedCalendar.job_ids.includes(_calendars.GLOBAL_CALENDAR)) {
            isGlobalCalendar = true;
          } else {
            selectedCalendar.job_ids.forEach(id => {
              if (jobIds.find(jobId => jobId === id)) {
                selectedJobOptions.push({
                  label: id
                });
              } else if (groupIds.find(groupId => groupId === id)) {
                selectedGroupOptions.push({
                  label: id
                });
              }
            });
          }
        }
      }
      this.setState({
        events: eventsList,
        formCalendarId,
        jobIds,
        jobIdOptions,
        groupIds,
        groupIdOptions,
        calendars,
        loading: false,
        selectedJobOptions,
        selectedGroupOptions,
        selectedCalendar,
        isGlobalCalendar
      });
    } catch (error) {
      this.setState({
        loading: false
      });
      this.toastNotificationService.displayErrorToast(error, _i18n.i18n.translate('xpack.ml.calendarsEdit.errorWithLoadingCalendarFromDataErrorMessage', {
        defaultMessage: 'An error occurred loading calendar form data. Try refreshing the page.'
      }));
    }
  }
  render() {
    const {
      events,
      isNewEventModalVisible,
      isImportModalVisible,
      isNewCalendarIdValid,
      formCalendarId,
      description,
      groupIdOptions,
      jobIdOptions,
      saving,
      loading,
      selectedCalendar,
      selectedJobOptions,
      selectedGroupOptions,
      isGlobalCalendar
    } = this.state;
    const helpLink = this.props.kibana.services.docLinks.links.ml.calendars;
    let modal = '';
    if (isNewEventModalVisible) {
      modal = /*#__PURE__*/_react.default.createElement(_new_event_modal.NewEventModal, {
        addEvent: this.addEvent,
        closeModal: this.closeNewEventModal
      });
    } else if (isImportModalVisible) {
      modal = /*#__PURE__*/_react.default.createElement(_import_modal.ImportModal, {
        addImportedEvents: this.addImportedEvents,
        closeImportModal: this.closeImportModal
      });
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "mlPageCalendarEdit"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_calendar_form.CalendarForm, {
      calendarId: selectedCalendar ? selectedCalendar.calendar_id : formCalendarId,
      description: selectedCalendar ? selectedCalendar.description : description,
      eventsList: events,
      groupIdOptions: groupIdOptions,
      isEdit: selectedCalendar !== undefined,
      isNewCalendarIdValid: selectedCalendar || isNewCalendarIdValid === null ? true : isNewCalendarIdValid,
      jobIdOptions: jobIdOptions,
      onCalendarIdChange: this.onCalendarIdChange,
      onCreate: this.onCreate,
      onDescriptionChange: this.onDescriptionChange,
      onEdit: this.onEdit,
      onEventDelete: this.onEventDelete,
      onGroupSelection: this.onGroupSelection,
      showImportModal: this.showImportModal,
      onJobSelection: this.onJobSelection,
      saving: saving,
      loading: loading,
      selectedGroupOptions: selectedGroupOptions,
      selectedJobOptions: selectedJobOptions,
      onCreateGroupOption: this.onCreateGroupOption,
      showNewEventModal: this.showNewEventModal,
      isGlobalCalendar: isGlobalCalendar,
      onGlobalCalendarChange: this.onGlobalCalendarChange,
      addEvents: this.addEvents,
      clearEvents: this.clearEvents,
      isDst: this.props.isDst
    }), modal)), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
      docLink: helpLink
    }));
  }
}
(0, _defineProperty2.default)(NewCalendarUI, "propTypes", {
  calendarId: _propTypes.PropTypes.string,
  isDst: _propTypes.PropTypes.bool.isRequired
});
const NewCalendar = exports.NewCalendar = (0, _public.withKibana)(NewCalendarUI);