"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobDetailsPane = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// fix for the annotation label being hidden inside the bounds of the chart container

const SectionItem = ({
  item
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const fontSize = euiTheme.size.m;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, null, item[0] !== '' && /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement("span", {
    css: {
      fontSize,
      fontWeight: 'bold'
    }
  }, item[0])), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement("span", {
    css: {
      fontSize
    }
  }, item[1])));
};
const Section = ({
  section
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (section.items.length === 0) {
    return /*#__PURE__*/_react.default.createElement("div", null);
  }
  const cssOverride = (0, _react2.css)({
    overflow: 'auto',
    padding: `${euiTheme.size.xs} ${euiTheme.size.m}`,
    backgroundColor: euiTheme.colors.lightestShade,
    border: `1px solid ${euiTheme.colors.lightShade}`,
    borderRadius: euiTheme.border.radius.medium,
    margin: `${euiTheme.size.s} 0`,
    '.euiTable': {
      backgroundColor: 'transparent'
    },
    '.euiTableRow:hover': {
      backgroundColor: 'inherit'
    },
    '.euiTableRow:first-child': {
      '.euiTableRowCell': {
        borderTop: 0
      }
    },
    '.euiTableRow:last-child': {
      '.euiTableRowCell': {
        borderBottom: 0
      }
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, section.title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, section.titleAction))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", {
    css: cssOverride,
    "data-test-subj": `mlJobRowDetailsSection-${section.id}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
    compressed: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, section.items.map((item, i) => /*#__PURE__*/_react.default.createElement(SectionItem, {
    item: item,
    key: i
  }))))))));
};
const JobDetailsPane = ({
  sections,
  ...props
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": props['data-test-subj']
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, sections.filter(s => s.position === 'left').map((s, i) => /*#__PURE__*/_react.default.createElement(Section, {
    section: s,
    key: i
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, sections.filter(s => s.position === 'right').map((s, i) => /*#__PURE__*/_react.default.createElement(Section, {
    section: s,
    key: i
  }))))));
};
exports.JobDetailsPane = JobDetailsPane;