"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMeasuredCharacterDimensions = exports.unwrappedContentStyle = exports.preWrappedContentStyle = exports.monospaceTextStyle = exports.longWrappedContentStyle = exports.hoveredContentStyle = exports.highlightedContentStyle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const monospaceTextStyle = scale => (0, _common.css)`
  font-family: ${props => props.theme.eui.euiCodeFontFamily};
  font-size: ${props => {
  switch (scale) {
    case 'large':
      return props.theme.eui.euiFontSizeM;
    case 'medium':
      return props.theme.eui.euiFontSizeS;
    case 'small':
      return props.theme.eui.euiFontSizeXS;
    default:
      return props.theme.eui.euiFontSize;
  }
}};
  line-height: ${props => props.theme.eui.euiLineHeight};
`;
exports.monospaceTextStyle = monospaceTextStyle;
const hoveredContentStyle = exports.hoveredContentStyle = (0, _common.css)`
  background-color: ${props => props.theme.eui.euiFocusBackgroundColor};
`;
const highlightedContentStyle = exports.highlightedContentStyle = (0, _common.css)`
  background-color: ${props => props.theme.eui.euiColorHighlight};
`;
const longWrappedContentStyle = exports.longWrappedContentStyle = (0, _common.css)`
  overflow: visible;
  white-space: pre-wrap;
  word-break: break-all;
`;
const preWrappedContentStyle = exports.preWrappedContentStyle = (0, _common.css)`
  overflow: hidden;
  white-space: pre;
`;
const unwrappedContentStyle = exports.unwrappedContentStyle = (0, _common.css)`
  overflow: hidden;
  white-space: nowrap;
`;
const useMeasuredCharacterDimensions = scale => {
  const [dimensions, setDimensions] = (0, _react.useState)({
    height: 0,
    width: 0
  });
  const measureElement = (0, _react.useCallback)(element => {
    if (!element) {
      return;
    }
    const boundingBox = element.getBoundingClientRect();
    setDimensions({
      height: boundingBox.height,
      width: boundingBox.width
    });
  }, []);
  const CharacterDimensionsProbe = (0, _react.useMemo)(() => () => /*#__PURE__*/_react.default.createElement(MonospaceCharacterDimensionsProbe, {
    scale: scale,
    ref: measureElement
  }, "X"), [measureElement, scale]);
  return {
    CharacterDimensionsProbe,
    dimensions
  };
};
exports.useMeasuredCharacterDimensions = useMeasuredCharacterDimensions;
const MonospaceCharacterDimensionsProbe = _common.euiStyled.div.attrs(() => ({
  'aria-hidden': true
}))`
  visibility: hidden;
  position: absolute;
  height: auto;
  width: auto;
  padding: 0;
  margin: 0;

  ${props => monospaceTextStyle(props.scale)};
`;