"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchDataViews = exports.loadDataViews = void 0;
var _comparator_by_field = require("../../../../utils/comparator_by_field");
var _data_view_descriptor = require("../../../../../common/data_views/models/data_view_descriptor");
var _state_machine = require("../state_machine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const loadDataViews = ({
  dataViews
}) => async context => {
  if (context.cache.has((0, _state_machine.getSearchCacheKey)(context))) {
    return context.cache.get((0, _state_machine.getSearchCacheKey)(context));
  }
  return dataViews.getIdsWithTitle().then(views => views.map(_data_view_descriptor.DataViewDescriptor.create)).then(views => searchDataViews(views, {
    search: context.search,
    filter: context.filter
  }));
};
exports.loadDataViews = loadDataViews;
const searchDataViews = (dataViews, searchCriteria) => {
  const {
    search,
    filter
  } = searchCriteria;
  const {
    name,
    sortOrder
  } = search;
  const {
    dataType
  } = filter;
  return dataViews.filter(dataView => {
    var _dataView$name;
    return Boolean((_dataView$name = dataView.name) === null || _dataView$name === void 0 ? void 0 : _dataView$name.includes(name !== null && name !== void 0 ? name : ''));
  }).filter(dataView => !dataType || Boolean(dataView.dataType === dataType)).sort((0, _comparator_by_field.createComparatorByField)('name', sortOrder));
};
exports.searchDataViews = searchDataViews;