"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangePopover = exports.AdvancedRangeEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _react2 = require("@emotion/react");
var _shared_components = require("../../../../../shared_components");
var _ranges = require("./ranges");
var _constants = require("./constants");
var _shared_components2 = require("../shared_components");
var _helpers = require("../helpers");
var _styles = require("../styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateId = (0, _eui.htmlIdGenerator)();
const getBetterLabel = (range, formatter) => range.label || formatter.convert({
  gte: (0, _helpers.isValidNumber)(range.from) ? range.from : -Infinity,
  lt: (0, _helpers.isValidNumber)(range.to) ? range.to : Infinity
});
const RangePopover = ({
  range,
  setRange,
  button,
  triggerClose,
  isOpen
}) => {
  const [tempRange, setTempRange] = (0, _react.useState)(range);
  const labelRef = _react.default.useRef();
  const toRef = _react.default.useRef();
  const saveRangeAndReset = (newRange, resetRange = false) => {
    if (resetRange) {
      // reset the temporary range for later use
      setTempRange(range);
    }
    // send the range back to the main state
    setRange(newRange);
  };
  const {
    from,
    to,
    label
  } = tempRange;
  const lteAppendLabel = _i18n.i18n.translate('xpack.lens.indexPattern.ranges.lessThanOrEqualAppend', {
    defaultMessage: '\u2264'
  });
  const lteTooltipContent = _i18n.i18n.translate('xpack.lens.indexPattern.ranges.lessThanOrEqualTooltip', {
    defaultMessage: 'Less than or equal to'
  });
  const ltPrependLabel = _i18n.i18n.translate('xpack.lens.indexPattern.ranges.lessThanPrepend', {
    defaultMessage: '\u003c'
  });
  const ltTooltipContent = _i18n.i18n.translate('xpack.lens.indexPattern.ranges.lessThanTooltip', {
    defaultMessage: 'Less than'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    display: "block",
    ownFocus: true,
    isOpen: isOpen,
    closePopover: () => triggerClose(),
    button: button,
    "data-test-subj": "indexPattern-ranges-popover"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    css: (0, _react2.css)`
                width: 14ch; // Roughly 10 characters plus extra for the padding
              `,
    value: (0, _helpers.isValidNumber)(from) ? Number(from) : '',
    onChange: ({
      target
    }) => {
      const newRange = {
        ...tempRange,
        from: target.value !== '' ? Number(target.value) : -Infinity
      };
      setTempRange(newRange);
      saveRangeAndReset(newRange);
    },
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: lteTooltipContent
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, lteAppendLabel)),
    onKeyDown: ({
      key
    }) => {
      if (_eui.keys.ENTER === key && toRef.current) {
        toRef.current.focus();
      }
    },
    compressed: true,
    placeholder: _constants.FROM_PLACEHOLDER,
    isInvalid: !(0, _ranges.isValidRange)(tempRange),
    step: 1
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortRight",
    color: "subdued"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    css: (0, _react2.css)`
                width: 14ch; // Roughly 10 characters plus extra for the padding
              `,
    value: (0, _helpers.isValidNumber)(to) ? Number(to) : '',
    inputRef: node => {
      if (toRef && node) {
        toRef.current = node;
      }
    },
    onChange: ({
      target
    }) => {
      const newRange = {
        ...tempRange,
        to: target.value !== '' ? Number(target.value) : Infinity
      };
      setTempRange(newRange);
      saveRangeAndReset(newRange);
    },
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: ltTooltipContent
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, ltPrependLabel)),
    compressed: true,
    placeholder: _constants.TO_PLACEHOLDER,
    isInvalid: !(0, _ranges.isValidRange)(tempRange),
    onKeyDown: ({
      key
    }) => {
      if (_eui.keys.ENTER === key && labelRef.current) {
        labelRef.current.focus();
      }
    },
    step: 1
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_shared_components2.LabelInput, {
    inputRef: labelRef,
    value: label || '',
    onChange: newLabel => {
      const newRange = {
        ...tempRange,
        label: newLabel
      };
      setTempRange(newRange);
      saveRangeAndReset(newRange);
    },
    placeholder: _i18n.i18n.translate('xpack.lens.indexPattern.ranges.customRangeLabelPlaceholder', {
      defaultMessage: 'Custom label'
    }),
    onSubmit: () => {
      triggerClose();
    },
    compressed: true,
    dataTestSubj: "indexPattern-ranges-label"
  })));
};
exports.RangePopover = RangePopover;
const AdvancedRangeEditor = ({
  ranges,
  setRanges,
  onToggleEditor,
  formatter
}) => {
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const [activeRangeId, setActiveRangeId] = (0, _react.useState)('');
  // use a local state to store ids with range objects
  const [localRanges, setLocalRanges] = (0, _react.useState)(() => ranges.map(range => ({
    ...range,
    id: generateId()
  })));

  // Update locally all the time, but bounce the parents prop function to avoid too many requests
  // Avoid to trigger on first render
  (0, _shared_components.useDebounceWithOptions)(() => {
    setRanges(localRanges.map(({
      id,
      ...rest
    }) => ({
      ...rest
    })));
  }, {
    skipFirstRender: true
  }, _constants.TYPING_DEBOUNCE_TIME, [localRanges]);
  const addNewRange = (0, _react.useCallback)(() => {
    const newRangeId = generateId();
    setLocalRanges([...localRanges, {
      id: newRangeId,
      from: localRanges[localRanges.length - 1].to,
      to: Number.POSITIVE_INFINITY,
      label: ''
    }]);
    setActiveRangeId(newRangeId);
  }, [localRanges]);
  const changeActiveRange = rangeId => {
    let newActiveRangeId = rangeId;
    if (activeRangeId === rangeId) {
      newActiveRangeId = ''; // toggle off
    }
    setActiveRangeId(newActiveRangeId);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.indexPattern.ranges.customRanges', {
      defaultMessage: 'Ranges'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      color: "danger",
      onClick: onToggleEditor
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      type: "cross",
      color: "danger"
    }), ' ', _i18n.i18n.translate('xpack.lens.indexPattern.ranges.customRangesRemoval', {
      defaultMessage: 'Remove custom ranges'
    })))
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.DragDropBuckets, {
    onDragEnd: setLocalRanges,
    droppableId: "RANGES_DROPPABLE_AREA",
    items: localRanges
  }, localRanges.map((range, idx, arrayRef) => /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.DraggableBucketContainer, {
    key: range.id,
    idx: idx,
    id: range.id,
    isInvalid: !(0, _ranges.isValidRange)(range),
    invalidMessage: _i18n.i18n.translate('xpack.lens.indexPattern.range.isInvalid', {
      defaultMessage: 'This range is invalid'
    }),
    onRemoveClick: () => {
      const newRanges = arrayRef.filter((_, i) => i !== idx);
      setLocalRanges(newRanges);
    },
    removeTitle: _i18n.i18n.translate('xpack.lens.indexPattern.ranges.deleteRange', {
      defaultMessage: 'Delete range'
    }),
    isNotRemovable: arrayRef.length === 1,
    isNotDraggable: arrayRef.length < 2
  }, /*#__PURE__*/_react.default.createElement(RangePopover, {
    range: range,
    isOpen: range.id === activeRangeId,
    triggerClose: () => changeActiveRange(''),
    setRange: newRange => {
      const newRanges = [...arrayRef];
      if (newRange.id === newRanges[idx].id) {
        newRanges[idx] = newRange;
      } else {
        newRanges.push(newRange);
      }
      setLocalRanges(newRanges);
    },
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      color: "text",
      onClick: () => changeActiveRange(range.id),
      "data-test-subj": "dataView-ranges-popover-trigger",
      css: (0, _styles.draggablePopoverButtonStyles)(euiThemeContext)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      textAlign: "left",
      color: (0, _ranges.isValidRange)(range) ? 'default' : 'danger'
    }, getBetterLabel(range, formatter)))
  })))), /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.NewBucketButton, {
    onClick: addNewRange,
    label: _i18n.i18n.translate('xpack.lens.indexPattern.ranges.addRange', {
      defaultMessage: 'Add range'
    })
  })));
};
exports.AdvancedRangeEditor = AdvancedRangeEditor;