"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.numberFormatter = exports.addResourceTypeToFilterQuery = void 0;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const addResourceTypeToFilterQuery = (filterQuery, resourceType) => {
  let validFilterQuery = _constants.DEFAULT_FILTER_QUERY;
  try {
    var _parsedFilterQuery$bo;
    const parsedFilterQuery = JSON.parse(filterQuery || '{}');
    if (!(parsedFilterQuery !== null && parsedFilterQuery !== void 0 && (_parsedFilterQuery$bo = parsedFilterQuery.bool) !== null && _parsedFilterQuery$bo !== void 0 && _parsedFilterQuery$bo.filter && Array.isArray(parsedFilterQuery.bool.filter))) {
      throw new Error('Invalid filter query');
    }
    parsedFilterQuery.bool.filter.push({
      bool: {
        should: [{
          match_phrase: {
            'orchestrator.resource.type': resourceType
          }
        }]
      }
    });
    validFilterQuery = JSON.stringify(parsedFilterQuery);
  } catch {
    // no-op since validFilterQuery is initialized to be DEFAULT_FILTER_QUERY
  }
  return validFilterQuery;
};
exports.addResourceTypeToFilterQuery = addResourceTypeToFilterQuery;
const numberFormatter = num => {
  if (Number.isFinite(num) && num >= 0) {
    if (num >= 1e15 - 1) {
      const newNum = Math.floor(num / 1e12) * 1e12;
      return new Intl.NumberFormat('en-GB', {
        // @ts-ignore
        notation: 'compact',
        compactDisplay: 'short'
      }).format(newNum);
    }
    // Trillion
    if (num >= 1e12 - 1) {
      const newNum = Math.floor(num / 1e9) * 1e9;
      return new Intl.NumberFormat('en-GB', {
        // @ts-ignore
        notation: 'compact',
        compactDisplay: 'short'
      }).format(newNum);
    }
    // Billion
    if (num >= 1e9 - 1) {
      const newNum = Math.floor(num / 1e6) * 1e6;
      return new Intl.NumberFormat('en-GB', {
        // @ts-ignore
        notation: 'compact',
        compactDisplay: 'short'
      }).format(newNum);
    }
    // Hundreds Thousands
    if (num >= 1e6 - 1) {
      const newNum = Math.floor(num / 1000) * 1000;
      return new Intl.NumberFormat('en-GB', {
        // @ts-ignore
        notation: 'compact',
        compactDisplay: 'short'
      }).format(newNum);
    }
    // Thousands
    if (num >= 1e3 - 1) {
      const newNum = Math.floor(num / 1000) * 1000;
      return new Intl.NumberFormat('en-GB', {
        // @ts-ignore
        notation: 'compact',
        compactDisplay: 'short'
      }).format(newNum);
    }
    if (num < 1e3) {
      return num.toString();
    }
    return new Intl.NumberFormat('en-GB', {
      // @ts-ignore
      notation: 'compact',
      compactDisplay: 'short'
    }).format(num);
  }
  return 'NaN';
};
exports.numberFormatter = numberFormatter;