"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applyDiff = applyDiff;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Filter the private vars
 * @param {string} key The keys
 * @returns {boolean}
 */
const filterPrivateAndMethods = function (obj) {
  return function (key) {
    if ((0, _lodash.isFunction)(obj[key])) return false;
    if (key.charAt(0) === '$') return false;
    return key.charAt(0) !== '_';
  };
};
function applyDiff(target, source) {
  const diff = {
    removed: [],
    added: [],
    changed: [],
    keys: []
  };
  const targetKeys = (0, _lodash.keys)(target).filter(filterPrivateAndMethods(target));
  const sourceKeys = (0, _lodash.keys)(source).filter(filterPrivateAndMethods(source));

  // Find the keys to be removed
  diff.removed = (0, _lodash.difference)(targetKeys, sourceKeys);

  // Find the keys to be added
  diff.added = (0, _lodash.difference)(sourceKeys, targetKeys);

  // Find the keys that will be changed
  diff.changed = (0, _lodash.filter)(sourceKeys, key => !(0, _lodash.isEqual)(target[key], source[key]));

  // Make a list of all the keys that are changing
  diff.keys = (0, _lodash.union)(diff.changed, diff.removed, diff.added);

  // Remove all the keys
  (0, _lodash.each)(diff.removed, key => {
    delete target[key];
  });

  // Assign the changed to the source to the target
  (0, _lodash.assign)(target, (0, _lodash.pick)(source, diff.changed));
  // Assign the added to the source to the target
  (0, _lodash.assign)(target, (0, _lodash.pick)(source, diff.added));
  return diff;
}