"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequestDetailsRequestContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lzString = require("lz-string");
var _public = require("@kbn/kibana-react-plugin/public");
var _req_code_viewer = require("./req_code_viewer");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/* eslint-disable @elastic/eui/href-or-on-click */

const openInConsoleLabel = _i18n.i18n.translate('inspector.requests.openInConsoleLabel', {
  defaultMessage: 'Open in Console'
});
const openInSearchProfilerLabel = _i18n.i18n.translate('inspector.requests.openInSearchProfilerLabel', {
  defaultMessage: 'Open in Search Profiler'
});
const RequestDetailsRequestContent = ({
  requestParams,
  indexPattern,
  json
}) => {
  var _services$application, _services$share$url$l, _services$application2, _services$application3, _services$share$url$l2, _services$application4, _services$application5;
  const {
    services
  } = (0, _public.useKibana)();
  function getValue() {
    if (!requestParams) {
      return json;
    }
    const fullPath = requestParams.querystring ? `${requestParams.path}?${requestParams.querystring}` : requestParams.path;
    return `${requestParams.method} ${fullPath}\n${json}`;
  }
  const value = getValue();
  const navigateToUrl = (_services$application = services.application) === null || _services$application === void 0 ? void 0 : _services$application.navigateToUrl;

  // "Open in Console" button
  const devToolsDataUri = (0, _lzString.compressToEncodedURIComponent)(value);
  const consoleHref = (_services$share$url$l = services.share.url.locators.get('CONSOLE_APP_LOCATOR')) === null || _services$share$url$l === void 0 ? void 0 : _services$share$url$l.useUrl({
    loadFrom: `data:text/plain,${devToolsDataUri}`
  });
  // Check if both the Dev Tools UI and the Console UI are enabled.
  const canShowDevTools = ((_services$application2 = services.application) === null || _services$application2 === void 0 ? void 0 : (_services$application3 = _services$application2.capabilities) === null || _services$application3 === void 0 ? void 0 : _services$application3.dev_tools.show) && consoleHref !== undefined;
  const shouldShowDevToolsLink = !!(requestParams && canShowDevTools);
  const handleDevToolsLinkClick = (0, _react.useCallback)(() => consoleHref && navigateToUrl && navigateToUrl(consoleHref), [consoleHref, navigateToUrl]);

  // "Open in Search Profiler" button
  const searchProfilerDataUri = (0, _lzString.compressToEncodedURIComponent)(json);
  const searchProfilerHref = (_services$share$url$l2 = services.share.url.locators.get('SEARCH_PROFILER_LOCATOR')) === null || _services$share$url$l2 === void 0 ? void 0 : _services$share$url$l2.useUrl({
    index: indexPattern,
    loadFrom: `data:text/plain,${searchProfilerDataUri}`
  });
  // Check if both the Dev Tools UI and the SearchProfiler UI are enabled.
  const canShowsearchProfiler = ((_services$application4 = services.application) === null || _services$application4 === void 0 ? void 0 : (_services$application5 = _services$application4.capabilities) === null || _services$application5 === void 0 ? void 0 : _services$application5.dev_tools.show) && searchProfilerHref !== undefined;
  const shouldShowSearchProfilerLink = !!(indexPattern && canShowsearchProfiler);
  const handleSearchProfilerLinkClick = (0, _react.useCallback)(() => searchProfilerHref && navigateToUrl && navigateToUrl(searchProfilerHref), [searchProfilerHref, navigateToUrl]);
  const actions = [];
  if (shouldShowDevToolsLink) {
    actions.push({
      name: 'openInConsole',
      action: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        flush: "right",
        iconType: "wrench",
        href: consoleHref,
        onClick: handleDevToolsLinkClick,
        "data-test-subj": "inspectorRequestOpenInConsoleButton"
      }, openInConsoleLabel)
    });
  }
  if (shouldShowSearchProfilerLink) {
    actions.push({
      name: 'openInSearchProfiler',
      action: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        flush: "right",
        iconType: "visBarHorizontal",
        href: searchProfilerHref,
        onClick: handleSearchProfilerLinkClick,
        "data-test-subj": "inspectorRequestOpenInSearchProfilerButton"
      }, openInSearchProfilerLabel)
    });
  }
  return /*#__PURE__*/_react.default.createElement(_req_code_viewer.RequestCodeViewer, {
    value: value,
    actions: actions
  });
};
exports.RequestDetailsRequestContent = RequestDetailsRequestContent;