"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serializeGeoipDatabase = exports.deserializeGeoipDatabase = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGeoipType = ({
  database
}) => {
  if (database.maxmind && database.maxmind.account_id) {
    return 'maxmind';
  }
  if (database.ipinfo) {
    return 'ipinfo';
  }
  if (database.local) {
    return 'local';
  }
  if (database.web) {
    return 'web';
  }
  return 'unknown';
};
const deserializeGeoipDatabase = geoipDatabase => {
  const {
    database,
    id
  } = geoipDatabase;
  return {
    name: database.name,
    id,
    type: getGeoipType(geoipDatabase)
  };
};
exports.deserializeGeoipDatabase = deserializeGeoipDatabase;
const serializeGeoipDatabase = ({
  databaseType,
  databaseName,
  maxmind
}) => {
  const database = {
    name: databaseName
  };
  if (databaseType === 'maxmind') {
    database.maxmind = {
      account_id: maxmind !== null && maxmind !== void 0 ? maxmind : ''
    };
  }
  if (databaseType === 'ipinfo') {
    database.ipinfo = {};
  }
  if (databaseType === 'local') {
    database.local = {};
  }
  if (databaseType === 'web') {
    database.web = {};
  }
  return database;
};
exports.serializeGeoipDatabase = serializeGeoipDatabase;