"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseInterval = exports.convertIntervalToString = exports.INTERVAL_STRING_RE = void 0;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INTERVAL_STRING_RE = exports.INTERVAL_STRING_RE = new RegExp(`^([\\d\\.]+)\\s*(${_datemath.default.units.join('|')})$`);
const parseInterval = intervalString => {
  if (intervalString) {
    const matches = intervalString.match(INTERVAL_STRING_RE);
    if (matches) {
      const value = Number(matches[1]);
      const unit = matches[2];
      return {
        value,
        unit
      };
    }
  }
  throw new Error(_i18n.i18n.translate('xpack.infra.parseInterval.errorMessage', {
    defaultMessage: '{value} is not an interval string',
    values: {
      value: intervalString
    }
  }));
};
exports.parseInterval = parseInterval;
const ValidUnitRT = rt.keyof({
  seconds: null,
  minutes: null,
  hours: null,
  days: null,
  weeks: null,
  months: null,
  years: null
});
const UNITS = ['seconds', 'minutes', 'hours', 'days', 'weeks', 'months', 'years'];
const DISPLAY_STRINGS_FOR_UNITS_PLURAL = {
  seconds: _i18n.i18n.translate('xpack.infra.durationUnits.seconds.plural', {
    defaultMessage: 'seconds'
  }),
  minutes: _i18n.i18n.translate('xpack.infra.durationUnits.minutes.plural', {
    defaultMessage: 'minutes'
  }),
  hours: _i18n.i18n.translate('xpack.infra.durationUnits.hours.plural', {
    defaultMessage: 'hours'
  }),
  days: _i18n.i18n.translate('xpack.infra.durationUnits.days.plural', {
    defaultMessage: 'days'
  }),
  weeks: _i18n.i18n.translate('xpack.infra.durationUnits.weeks.plural', {
    defaultMessage: 'weeks'
  }),
  months: _i18n.i18n.translate('xpack.infra.durationUnits.months.plural', {
    defaultMessage: 'months'
  }),
  years: _i18n.i18n.translate('xpack.infra.durationUnits.years.plural', {
    defaultMessage: 'years'
  })
};
const DISPLAY_STRINGS_FOR_UNITS_SINGULAR = {
  seconds: _i18n.i18n.translate('xpack.infra.durationUnits.seconds.singular', {
    defaultMessage: 'second'
  }),
  minutes: _i18n.i18n.translate('xpack.infra.durationUnits.minutes.singular', {
    defaultMessage: 'minute'
  }),
  hours: _i18n.i18n.translate('xpack.infra.durationUnits.hours.singular', {
    defaultMessage: 'hour'
  }),
  days: _i18n.i18n.translate('xpack.infra.durationUnits.days.singular', {
    defaultMessage: 'day'
  }),
  weeks: _i18n.i18n.translate('xpack.infra.durationUnits.weeks.singular', {
    defaultMessage: 'week'
  }),
  months: _i18n.i18n.translate('xpack.infra.durationUnits.months.singular', {
    defaultMessage: 'month'
  }),
  years: _i18n.i18n.translate('xpack.infra.durationUnits.years.singular', {
    defaultMessage: 'year'
  })
};
const getDisplayableUnit = (value, unit) => {
  return Math.floor(value) === 1 ? DISPLAY_STRINGS_FOR_UNITS_SINGULAR[unit] : DISPLAY_STRINGS_FOR_UNITS_PLURAL[unit];
};
const convertIntervalToString = input => {
  const interval = parseInterval(input);
  if ((interval === null || interval === void 0 ? void 0 : interval.unit) === 's') {
    const duration = _moment.default.duration(interval.value, interval.unit);
    const targetUnit = UNITS.reduce((answer, unit) => {
      if (duration.as(unit) >= 1) {
        return unit;
      }
      return answer;
    }, 'seconds');
    const durationAsUnit = duration.as(targetUnit);
    return `${Math.floor(durationAsUnit)} ${getDisplayableUnit(durationAsUnit, targetUnit)}`;
  }
};
exports.convertIntervalToString = convertIntervalToString;