"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnapshotPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _public2 = require("@kbn/core/public");
var _react2 = require("@emotion/react");
var _no_data_config = require("../../../components/shared/templates/no_data_config");
var _infra_page_template = require("../../../components/shared/templates/infra_page_template");
var _use_metrics_breadcrumbs = require("../../../hooks/use_metrics_breadcrumbs");
var _translations = require("../../../translations");
var _saved_views = require("./components/saved_views");
var _snapshot_container = require("./components/snapshot_container");
var _page_template = require("../../../page_template.styles");
var _survey_section = require("./components/survey_section");
var _use_waffle_options = require("./hooks/use_waffle_options");
var _use_waffle_time = require("./hooks/use_waffle_time");
var _use_waffle_filters = require("./hooks/use_waffle_filters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SnapshotPage = () => {
  (0, _public.useTrackPageview)({
    app: 'infra_metrics',
    path: 'inventory'
  });
  (0, _public.useTrackPageview)({
    app: 'infra_metrics',
    path: 'inventory',
    delay: 15000
  });
  (0, _use_metrics_breadcrumbs.useMetricsBreadcrumbs)([{
    text: _translations.inventoryTitle
  }]);
  return /*#__PURE__*/_react.default.createElement(_use_waffle_options.WaffleOptionsProvider, null, /*#__PURE__*/_react.default.createElement(_use_waffle_time.WaffleTimeProvider, null, /*#__PURE__*/_react.default.createElement(_use_waffle_filters.WaffleFiltersProvider, null, /*#__PURE__*/_react.default.createElement("div", {
    className: _public2.APP_WRAPPER_CLASS
  }, /*#__PURE__*/_react.default.createElement(_infra_page_template.InfraPageTemplate, {
    onboardingFlow: _no_data_config.OnboardingFlow.Infra,
    pageHeader: {
      pageTitle: _translations.inventoryTitle,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_saved_views.SavedViews, null), /*#__PURE__*/_react.default.createElement(_survey_section.SurveySection, null)]
    },
    pageSectionProps: {
      contentProps: {
        css: (0, _react2.css)`
                    ${_page_template.fullHeightContentStyles};
                    padding-bottom: 0;
                  `
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_snapshot_container.SnapshotContainer, null))))));
};
exports.SnapshotPage = SnapshotPage;