"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeSquare = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _polished = require("polished");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SquareContent = ({
  children,
  css: contentStyle,
  ...props
}) => /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
  css: (0, _react2.css)`
      text-align: center;
      width: 100%;
      overflow: hidden;
      text-overflow: ellipsis;
      white-space: nowrap;
      flex: 1 0 auto;
      color: ${(0, _polished.readableColor)(props.color)};
    `
}, props), children);
const NodeContainer = ({
  children,
  ...props
}) => /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
  css: (0, _react2.css)`
      position: relative;
      cursor: pointer;
    `
}, props), children);
const NodeContainerSmall = ({
  children,
  ...props
}) => /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
  css: (0, _react2.css)`
      cursor: pointer;
      position: relative;
      background-color: ${(0, _polished.darken)(0.1, props.color)};
      border-radius: 3px;
      margin: 2px;
      box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.2);
    `
}, props), children);
const ValueInner = ({
  children,
  ...props
}) => /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
  css: (0, _react2.css)`
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      display: flex;
      line-height: 1.2em;
      align-items: center;
      align-content: center;
      padding: 1em;
      overflow: hidden;
      flex-wrap: wrap;
      width: 100%;
      border: none;
      &:focus {
        outline: none !important;
        border: ${_uiTheme.euiThemeVars.euiFocusRingSize} solid ${_uiTheme.euiThemeVars.euiFocusRingColor};
        box-shadow: none;
      }
    `,
  tabIndex: 0
}, props), children);
const SquareOuter = ({
  children,
  ...props
}) => /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
  css: (0, _react2.css)`
      position: absolute;
      top: 4px;
      left: 4px;
      bottom: 4px;
      right: 4px;
      background-color: ${(0, _polished.darken)(0.1, props.color)};
      border-radius: 3px;
      box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.2);
    `
}, props), children);
const SquareInner = ({
  children,
  ...props
}) => /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
  css: (0, _react2.css)`
      position: absolute;
      top: 0;
      right: 0;
      bottom: 2px;
      left: 0;
      border-radius: 3px;
      background-color: ${props.color};
    `
}, props), children);
const Label = ({
  children,
  ...props
}) => /*#__PURE__*/_react.default.createElement(SquareContent, (0, _extends2.default)({
  css: (0, _react2.css)`
      font-size: 0.7em;
      margin-bottom: 0.7em;
    `
}, props), children);
const Value = ({
  children,
  ...props
}) => /*#__PURE__*/_react.default.createElement(SquareContent, (0, _extends2.default)({
  css: (0, _react2.css)`
      font-weight: bold;
      font-size: 0.9em;
      line-height: 1.2em;
    `
}, props), children);
const NodeSquare = ({
  squareSize,
  togglePopover,
  color,
  nodeName,
  value,
  showBorder,
  nodeMetric
}) => {
  const valueMode = squareSize > 70;
  const ellipsisMode = squareSize > 30;
  const nodeAriaLabel = _i18n.i18n.translate('xpack.infra.node.ariaLabel', {
    defaultMessage: '{nodeName} {value} {nodeMetric} ',
    values: {
      nodeName,
      nodeMetric,
      value
    }
  });
  const style = showBorder ? {
    border: 'solid 4px #000'
  } : undefined;
  return valueMode || ellipsisMode ? /*#__PURE__*/_react.default.createElement(NodeContainer, {
    "data-test-subj": "nodeContainer",
    style: {
      width: squareSize || 0,
      height: squareSize || 0
    },
    onClick: togglePopover,
    className: "buttonContainer"
  }, /*#__PURE__*/_react.default.createElement(SquareOuter, {
    color: color,
    style: style
  }, /*#__PURE__*/_react.default.createElement(SquareInner, {
    color: color
  }, valueMode ? /*#__PURE__*/_react.default.createElement(ValueInner, {
    "aria-label": nodeAriaLabel
  }, /*#__PURE__*/_react.default.createElement(Label, {
    "data-test-subj": "nodeName",
    color: color
  }, nodeName), /*#__PURE__*/_react.default.createElement(Value, {
    "data-test-subj": "nodeValue",
    color: color
  }, value)) : ellipsisMode && /*#__PURE__*/_react.default.createElement(ValueInner, {
    "aria-label": nodeAriaLabel
  }, /*#__PURE__*/_react.default.createElement(Label, {
    color: color
  }, '...'))))) : /*#__PURE__*/_react.default.createElement(NodeContainerSmall, {
    "data-test-subj": "nodeContainer",
    style: {
      width: squareSize || 0,
      height: squareSize || 0,
      ...style
    },
    onClick: togglePopover,
    onKeyPress: togglePopover,
    color: color,
    tabIndex: 0
  });
};
exports.NodeSquare = NodeSquare;