"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexMgmtUIPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _semver = _interopRequireDefault(require("semver/classes/semver"));
var _react = _interopRequireDefault(require("react"));
var _extension_service = require("./application/store/selectors/extension_service");
var _extensions_service = require("./services/extensions_service");
var _plugin = require("../common/constants/plugin");
var _index_mappings_embeddable = require("./application/sections/home/index_list/details_page/with_context_components/index_mappings_embeddable");
var _public_api_service = require("./services/public_api_service");
var _index_settings_embeddable = require("./application/sections/home/index_list/details_page/with_context_components/index_settings_embeddable");
var _locator = require("./locator");
var _component_templates_flyout_embeddable = require("./application/components/component_templates/component_templates_flyout_embeddable");
var _data_stream_flyout_embeddable = require("./application/sections/home/data_stream_list/data_stream_detail_panel/data_stream_flyout_embeddable");
var _index_template_flyout_embeddable = require("./application/sections/home/template_list/template_details/index_template_flyout_embeddable");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */ // avoid import from index files in plugin.ts, use specific import paths
class IndexMgmtUIPlugin {
  constructor(ctx) {
    (0, _defineProperty2.default)(this, "extensionsService", new _extensions_service.ExtensionsService());
    (0, _defineProperty2.default)(this, "locator", void 0);
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "canUseSyntheticSource", false);
    (0, _defineProperty2.default)(this, "licensingSubscription", void 0);
    (0, _defineProperty2.default)(this, "capabilities$", new _rxjs.Subject());
    // Temporary hack to provide the service instances in module files in order to avoid a big refactor
    // For the selectors we should expose them through app dependencies and read them from there on each container component.
    (0, _extension_service.setExtensionsService)(this.extensionsService);
    this.kibanaVersion = new _semver.default(ctx.env.packageInfo.version);
    const {
      ui: {
        enabled: isIndexManagementUiEnabled
      },
      enableIndexActions,
      enableLegacyTemplates,
      enableIndexStats,
      enableDataStreamStats,
      enableSizeAndDocCount,
      editableIndexSettings,
      enableMappingsSourceFieldSection,
      enableTogglingDataRetention,
      enableProjectLevelRetentionChecks,
      dev: {
        enableSemanticText
      }
    } = ctx.config.get();
    this.config = {
      isIndexManagementUiEnabled,
      enableIndexActions: enableIndexActions !== null && enableIndexActions !== void 0 ? enableIndexActions : true,
      enableLegacyTemplates: enableLegacyTemplates !== null && enableLegacyTemplates !== void 0 ? enableLegacyTemplates : true,
      enableIndexStats: enableIndexStats !== null && enableIndexStats !== void 0 ? enableIndexStats : true,
      enableDataStreamStats: enableDataStreamStats !== null && enableDataStreamStats !== void 0 ? enableDataStreamStats : true,
      enableSizeAndDocCount: enableSizeAndDocCount !== null && enableSizeAndDocCount !== void 0 ? enableSizeAndDocCount : false,
      editableIndexSettings: editableIndexSettings !== null && editableIndexSettings !== void 0 ? editableIndexSettings : 'all',
      enableMappingsSourceFieldSection: enableMappingsSourceFieldSection !== null && enableMappingsSourceFieldSection !== void 0 ? enableMappingsSourceFieldSection : true,
      enableTogglingDataRetention: enableTogglingDataRetention !== null && enableTogglingDataRetention !== void 0 ? enableTogglingDataRetention : true,
      enableProjectLevelRetentionChecks: enableProjectLevelRetentionChecks !== null && enableProjectLevelRetentionChecks !== void 0 ? enableProjectLevelRetentionChecks : false,
      enableSemanticText: enableSemanticText !== null && enableSemanticText !== void 0 ? enableSemanticText : true
    };
  }
  setup(coreSetup, plugins) {
    const {
      fleet,
      usageCollection,
      management,
      cloud
    } = plugins;
    this.capabilities$.subscribe(capabilities => {
      const {
        monitor,
        manageEnrich,
        monitorEnrich,
        manageIndexTemplates
      } = capabilities.index_management;
      if (this.config.isIndexManagementUiEnabled && (monitor || manageEnrich || monitorEnrich || manageIndexTemplates)) {
        management.sections.section.data.registerApp({
          id: _plugin.PLUGIN.id,
          title: _i18n.i18n.translate('xpack.idxMgmt.appTitle', {
            defaultMessage: 'Index Management'
          }),
          order: 0,
          mount: async params => {
            const {
              mountManagementSection
            } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/mount_management_section')));
            return mountManagementSection({
              coreSetup,
              usageCollection,
              params,
              extensionsService: this.extensionsService,
              isFleetEnabled: Boolean(fleet),
              kibanaVersion: this.kibanaVersion,
              config: this.config,
              cloud,
              canUseSyntheticSource: this.canUseSyntheticSource
            });
          }
        });
      }
    });
    this.locator = plugins.share.url.locators.create(new _locator.IndexManagementLocatorDefinition({
      managementAppLocator: plugins.management.locator
    }));
    return {
      apiService: new _public_api_service.PublicApiService(coreSetup.http),
      extensionsService: this.extensionsService.setup(),
      locator: this.locator
    };
  }
  buildComponentDependencies(core, plugins, deps) {
    const {
      fleet,
      usageCollection,
      cloud,
      share,
      console,
      ml,
      licensing
    } = plugins;
    const {
      docLinks,
      fatalErrors,
      application,
      uiSettings,
      executionContext,
      settings,
      http
    } = core;
    const {
      monitor,
      manageEnrich,
      monitorEnrich,
      manageIndexTemplates
    } = application.capabilities.index_management;
    const {
      url
    } = share;
    const dependencies = {
      core: {
        fatalErrors,
        getUrlForApp: application.getUrlForApp,
        executionContext,
        application,
        http,
        i18n: core.i18n,
        theme: core.theme,
        chrome: core.chrome
      },
      plugins: {
        usageCollection,
        isFleetEnabled: Boolean(fleet),
        share,
        cloud,
        console,
        ml,
        licensing
      },
      services: {
        extensionsService: this.extensionsService
      },
      config: this.config,
      history: deps.history,
      canUseSyntheticSource: this.canUseSyntheticSource,
      overlays: core.overlays,
      privs: {
        monitor: !!monitor,
        manageEnrich: !!manageEnrich,
        monitorEnrich: !!monitorEnrich,
        manageIndexTemplates: !!manageIndexTemplates
      },
      setBreadcrumbs: () => {},
      uiSettings,
      settings,
      url,
      docLinks,
      kibanaVersion: this.kibanaVersion,
      theme$: core.theme.theme$
    };
    return {
      dependencies,
      core,
      usageCollection
    };
  }
  start(coreStart, plugins) {
    const {
      licensing
    } = plugins;
    this.capabilities$.next(coreStart.application.capabilities);
    this.licensingSubscription = licensing === null || licensing === void 0 ? void 0 : licensing.license$.subscribe(next => {
      this.canUseSyntheticSource = next.hasAtLeast('enterprise');
    });
    return {
      extensionsService: this.extensionsService.setup(),
      getIndexMappingComponent: deps => {
        return props => {
          return (0, _index_mappings_embeddable.IndexMapping)({
            ...this.buildComponentDependencies(coreStart, plugins, deps),
            ...props
          });
        };
      },
      getIndexSettingsComponent: deps => {
        return props => {
          return /*#__PURE__*/_react.default.createElement(_index_settings_embeddable.IndexSettings, {
            ...this.buildComponentDependencies(coreStart, plugins, deps),
            ...props
          });
        };
      },
      getComponentTemplateFlyoutComponent: deps => {
        return props => {
          return /*#__PURE__*/_react.default.createElement(_component_templates_flyout_embeddable.ComponentTemplateFlyout, {
            ...this.buildComponentDependencies(coreStart, plugins, deps),
            ...props
          });
        };
      },
      getIndexTemplateFlyoutComponent: deps => {
        return props => {
          return /*#__PURE__*/_react.default.createElement(_index_template_flyout_embeddable.IndexTemplateFlyout, {
            ...this.buildComponentDependencies(coreStart, plugins, deps),
            ...props
          });
        };
      },
      getDatastreamFlyoutComponent: deps => {
        return props => {
          return /*#__PURE__*/_react.default.createElement(_data_stream_flyout_embeddable.DataStreamFlyout, {
            ...this.buildComponentDependencies(coreStart, plugins, deps),
            ...props
          });
        };
      }
    };
  }
  stop() {
    var _this$licensingSubscr;
    (_this$licensingSubscr = this.licensingSubscription) === null || _this$licensingSubscr === void 0 ? void 0 : _this$licensingSubscr.unsubscribe();
  }
}
exports.IndexMgmtUIPlugin = IndexMgmtUIPlugin;