"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = exports.ServerConfig = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _configSchema = require("@kbn/config-schema");
var _serverHttpTools = require("@kbn/server-http-tools");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const configSchema = _configSchema.schema.object({
  host: _configSchema.schema.string({
    defaultValue: 'localhost',
    hostname: true
  }),
  port: _configSchema.schema.number({
    defaultValue: 3000
  }),
  maxPayload: _configSchema.schema.byteSize({
    defaultValue: '1048576b'
  }),
  keepaliveTimeout: _configSchema.schema.number({
    defaultValue: 120000
  }),
  payloadTimeout: _configSchema.schema.number({
    defaultValue: 20000
  }),
  shutdownTimeout: _configSchema.schema.duration({
    defaultValue: '30s',
    validate: duration => {
      const durationMs = duration.asMilliseconds();
      if (durationMs < 1000 || durationMs > 2 * 60 * 1000) {
        return 'the value should be between 1 second and 2 minutes';
      }
    }
  }),
  socketTimeout: _configSchema.schema.number({
    defaultValue: 120000
  }),
  ssl: _serverHttpTools.sslSchema,
  restrictInternalApis: _configSchema.schema.boolean({
    defaultValue: false
  })
}, {
  validate: rawConfig => {
    if (rawConfig.ssl.enabled && rawConfig.ssl.redirectHttpFromPort !== undefined && rawConfig.ssl.redirectHttpFromPort === rawConfig.port) {
      return 'The health gateway does not accept http traffic to [port] when ssl is ' + 'enabled (only https is allowed), so [ssl.redirectHttpFromPort] ' + `cannot be configured to the same value. Both are [${rawConfig.port}].`;
    }
  }
});
const config = exports.config = {
  path: 'server',
  schema: configSchema
};
class ServerConfig {
  constructor(rawConfig) {
    (0, _defineProperty2.default)(this, "protocol", 'http1');
    (0, _defineProperty2.default)(this, "host", void 0);
    (0, _defineProperty2.default)(this, "port", void 0);
    (0, _defineProperty2.default)(this, "maxPayload", void 0);
    (0, _defineProperty2.default)(this, "keepaliveTimeout", void 0);
    (0, _defineProperty2.default)(this, "shutdownTimeout", void 0);
    (0, _defineProperty2.default)(this, "socketTimeout", void 0);
    (0, _defineProperty2.default)(this, "payloadTimeout", void 0);
    (0, _defineProperty2.default)(this, "ssl", void 0);
    (0, _defineProperty2.default)(this, "cors", void 0);
    (0, _defineProperty2.default)(this, "restrictInternalApis", void 0);
    this.host = rawConfig.host;
    this.port = rawConfig.port;
    this.maxPayload = rawConfig.maxPayload;
    this.keepaliveTimeout = rawConfig.keepaliveTimeout;
    this.shutdownTimeout = rawConfig.shutdownTimeout;
    this.socketTimeout = rawConfig.socketTimeout;
    this.payloadTimeout = rawConfig.payloadTimeout;
    this.ssl = new _serverHttpTools.SslConfig(rawConfig.ssl);
    this.cors = {
      enabled: false,
      allowCredentials: false,
      allowOrigin: ['*']
    };
    this.restrictInternalApis = rawConfig.restrictInternalApis;
  }
}
exports.ServerConfig = ServerConfig;