"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Server = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _serverHttpTools = require("@kbn/server-http-tools");
var _server_config = require("./server_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * A very thin wrapper around Hapi, which only exposes the functionality we
 * need for this app.
 */
class Server {
  constructor({
    logger,
    config
  }) {
    (0, _defineProperty2.default)(this, "log", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "server", void 0);
    this.log = logger.get('server');
    this.config = config;
  }
  async start() {
    const serverConfig = new _server_config.ServerConfig(this.config.atPathSync('server'));
    this.server = (0, _serverHttpTools.createServer)((0, _serverHttpTools.getServerOptions)(serverConfig));
    await this.server.start();
    this.log.info(`Server running on ${this.server.info.uri}`);
    return {
      addRoute: definition => {
        this.log.debug(`Registering route handler for [${definition.path}]`);
        this.server.route(definition);
      }
    };
  }
  async stop() {
    this.log.debug('Attempting graceful shutdown');
    if (this.server) {
      await this.server.stop();
    }
  }
}
exports.Server = Server;