"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentDetailsPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../constants");
var _components = require("../../../components");
var _hooks = require("../../../hooks");
var _layouts = require("../../../layouts");
var _services = require("../../../services");
var _hooks2 = require("./hooks");
var _components2 = require("./components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentDetailsPage = () => {
  var _agentData$item, _agentData$item2, _agentData$item2$loca;
  const {
    params: {
      agentId,
      tabId = ''
    }
  } = (0, _reactRouterDom.useRouteMatch)();
  const {
    getHref
  } = (0, _hooks.useLink)();
  const {
    displayAgentMetrics
  } = _services.ExperimentalFeaturesService.get();
  const {
    isLoading,
    isInitialRequest,
    error,
    data: agentData,
    resendRequest: sendAgentRequest
  } = (0, _hooks.useGetOneAgent)(agentId, {
    pollIntervalMs: 5000,
    query: {
      withMetrics: displayAgentMetrics
    }
  });
  const {
    isLoading: isAgentPolicyLoading,
    data: agentPolicyData,
    sendRequest: sendAgentPolicyRequest
  } = (0, _hooks.useGetOneAgentPolicy)(agentData === null || agentData === void 0 ? void 0 : (_agentData$item = agentData.item) === null || _agentData$item === void 0 ? void 0 : _agentData$item.policy_id);
  const {
    application: {
      navigateToApp
    }
  } = (0, _hooks.useStartServices)();
  const routeState = (0, _hooks.useIntraAppState)();
  const queryParams = new URLSearchParams((0, _reactRouterDom.useLocation)().search);
  const openReassignFlyoutOpenByDefault = queryParams.get('openReassignFlyout') === 'true';
  const reassignCancelClickHandler = (0, _react.useCallback)(() => {
    if (routeState && routeState.onDoneNavigateTo) {
      navigateToApp(routeState.onDoneNavigateTo[0], routeState.onDoneNavigateTo[1]);
    }
  }, [routeState, navigateToApp]);
  const {
    diagnosticFileUploadEnabled
  } = _services.ExperimentalFeaturesService.get();
  const host = agentData === null || agentData === void 0 ? void 0 : (_agentData$item2 = agentData.item) === null || _agentData$item2 === void 0 ? void 0 : (_agentData$item2$loca = _agentData$item2.local_metadata) === null || _agentData$item2$loca === void 0 ? void 0 : _agentData$item2$loca.host;
  const headerLeftContent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "arrowLeft",
    href: getHref('agent_list'),
    flush: "left",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentDetails.viewAgentListTitle",
    defaultMessage: "View all agents"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-textBreakWord"
  }, /*#__PURE__*/_react.default.createElement("h1", null, isLoading && isInitialRequest ? /*#__PURE__*/_react.default.createElement(_components.Loading, null) : typeof host === 'object' && typeof (host === null || host === void 0 ? void 0 : host.hostname) === 'string' ? host.hostname : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentDetails.agentDetailsTitle",
    defaultMessage: "Agent ''{id}''",
    values: {
      id: agentId
    }
  }))))), [host, agentId, getHref, isInitialRequest, isLoading]);
  const headerRightContent = (0, _react.useMemo)(() => agentData && agentData.item ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    gutterSize: "s",
    direction: "row"
  }, !isAgentPolicyLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components2.AgentDetailsActionMenu, {
    agent: agentData.item,
    agentPolicy: agentPolicyData === null || agentPolicyData === void 0 ? void 0 : agentPolicyData.item,
    assignFlyoutOpenByDefault: openReassignFlyoutOpenByDefault,
    onCancelReassign: routeState && routeState.onDoneNavigateTo ? reassignCancelClickHandler : undefined
  })))) : undefined, /* eslint-disable-next-line react-hooks/exhaustive-deps */
  [agentPolicyData, agentData, getHref, isAgentPolicyLoading]);
  const headerTabs = (0, _react.useMemo)(() => {
    const tabs = [{
      id: 'details',
      name: _i18n.i18n.translate('xpack.fleet.agentDetails.subTabs.detailsTab', {
        defaultMessage: 'Agent details'
      }),
      href: getHref('agent_details', {
        agentId,
        tabId: 'details'
      }),
      isSelected: !tabId || tabId === 'details'
    }, {
      id: 'logs',
      name: _i18n.i18n.translate('xpack.fleet.agentDetails.subTabs.logsTab', {
        defaultMessage: 'Logs'
      }),
      href: getHref('agent_details_logs', {
        agentId,
        tabId: 'logs'
      }),
      isSelected: tabId === 'logs'
    }];
    if (diagnosticFileUploadEnabled) {
      tabs.push({
        id: 'diagnostics',
        name: _i18n.i18n.translate('xpack.fleet.agentDetails.subTabs.diagnosticsTab', {
          defaultMessage: 'Diagnostics'
        }),
        href: getHref('agent_details_diagnostics', {
          agentId,
          tabId: 'diagnostics'
        }),
        isSelected: tabId === 'diagnostics'
      });
    }
    return tabs;
  }, [getHref, agentId, tabId, diagnosticFileUploadEnabled]);
  return /*#__PURE__*/_react.default.createElement(_hooks2.AgentRefreshContext.Provider, {
    value: {
      refresh: () => {
        sendAgentRequest();
        sendAgentPolicyRequest();
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_layouts.WithHeaderLayout, {
    leftColumn: headerLeftContent,
    rightColumn: headerRightContent,
    tabs: headerTabs
  }, isLoading && isInitialRequest ? /*#__PURE__*/_react.default.createElement(_components.Loading, null) : error ? /*#__PURE__*/_react.default.createElement(_components.Error, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentDetails.unexceptedErrorTitle",
      defaultMessage: "Error loading agent"
    }),
    error: error
  }) : agentData && agentData.item ? /*#__PURE__*/_react.default.createElement(AgentDetailsPageContent, {
    agent: agentData.item,
    agentPolicy: agentPolicyData === null || agentPolicyData === void 0 ? void 0 : agentPolicyData.item
  }) : /*#__PURE__*/_react.default.createElement(_components.Error, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentDetails.agentNotFoundErrorTitle",
      defaultMessage: "Agent not found"
    }),
    error: _i18n.i18n.translate('xpack.fleet.agentDetails.agentNotFoundErrorDescription', {
      defaultMessage: 'Cannot find agent ID {agentId}',
      values: {
        agentId
      }
    })
  })));
};
exports.AgentDetailsPage = AgentDetailsPage;
const AgentDetailsPageContent = ({
  agent,
  agentPolicy
}) => {
  (0, _hooks.useBreadcrumbs)('agent_details', {
    agentHost: typeof agent.local_metadata.host === 'object' && typeof agent.local_metadata.host.hostname === 'string' ? agent.local_metadata.host.hostname : '-'
  });
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.agent_details_logs,
    render: () => {
      return /*#__PURE__*/_react.default.createElement(_components2.AgentLogs, {
        agent: agent,
        agentPolicy: agentPolicy
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.agent_details_diagnostics,
    render: () => {
      return /*#__PURE__*/_react.default.createElement(_components2.AgentDiagnosticsTab, {
        agent: agent
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.agent_details,
    render: () => {
      return /*#__PURE__*/_react.default.createElement(_components2.AgentDetailsContent, {
        agent: agent,
        agentPolicy: agentPolicy
      });
    }
  }));
};