"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RolesEmptyPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _deprecation_callout = require("../deprecation_callout/deprecation_callout");
var _doc_links = require("../doc_links");
var _kibana_logic = require("../kibana/kibana_logic");
var _constants2 = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RolesEmptyPrompt = ({
  onEnable,
  docsLink,
  productName
}) => {
  const {
    user: currentUser
  } = (0, _kea.useValues)(_kibana_logic.KibanaLogic);
  const isSuperUser = currentUser === null || currentUser === void 0 ? void 0 : currentUser.roles.includes('superuser');
  const rbacDisabledLabel = !isSuperUser && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    "data-test-subj": "rbacDisabledLabel"
  }, _constants2.RBAC_BUTTON_DISABLED_LABEL);
  const [showDeprecationCallout, setShowDeprecationCallout] = _react.default.useState(!sessionStorage.getItem('appSearchHideDeprecationCallout'));
  const onDismissDeprecationCallout = () => {
    setShowDeprecationCallout(false);
    sessionStorage.setItem('appSearchHideDeprecationCallout', 'true');
  };
  if (!currentUser) {
    return null;
  }
  const deprecationLearnMoreLink = productName === _constants.APP_SEARCH_PLUGIN.NAME ? _doc_links.docLinks.appSearchGuide : _doc_links.docLinks.workplaceSearchGuide;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showDeprecationCallout ? /*#__PURE__*/_react.default.createElement(_deprecation_callout.EnterpriseSearchDeprecationCallout, {
    onDismissAction: onDismissDeprecationCallout,
    learnMoreLinkUrl: deprecationLearnMoreLink,
    restrictWidth: true
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "lockOpen",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _constants2.ROLES_DISABLED_TITLE),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, (0, _constants2.ROLES_DISABLED_DESCRIPTION)(productName)), /*#__PURE__*/_react.default.createElement("p", null, _constants2.ROLES_DISABLED_NOTE)),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "enterpriseSearchRolesEmptyPromptButton",
      disabled: !isSuperUser,
      key: "enableRolesButton",
      fill: true,
      onClick: onEnable
    }, _constants2.ENABLE_ROLES_BUTTON), rbacDisabledLabel, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      key: "spacer",
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "enterpriseSearchRolesEmptyPromptLink",
      key: "enableRolesLink",
      href: docsLink,
      target: "_blank",
      external: true
    }, _constants2.ENABLE_ROLES_LINK)]
  }));
};
exports.RolesEmptyPrompt = RolesEmptyPrompt;