"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CredentialsFlyoutHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
var _credentials_logic = require("../credentials_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CredentialsFlyoutHeader = () => {
  const {
    activeApiToken
  } = (0, _kea.useValues)(_credentials_logic.CredentialsLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: _constants.FLYOUT_ARIA_LABEL_ID
  }, activeApiToken.id ? _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.flyout.updateTitle', {
    defaultMessage: 'Update {tokenName}',
    values: {
      tokenName: activeApiToken.name
    }
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.flyout.createTitle', {
    defaultMessage: 'Create a new key'
  }))));
};
exports.CredentialsFlyoutHeader = CredentialsFlyoutHeader;