"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationsSelector = IntegrationsSelector;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _common = require("../../common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const integrationsSelectorLabel = _i18n.i18n.translate('xpack.datasetQuality.integrationsSelectorLabel', {
  defaultMessage: 'Integrations'
});
const integrationsSelectorLoading = _i18n.i18n.translate('xpack.datasetQuality.integrationsSelectorLoading', {
  defaultMessage: 'Loading integrations'
});
const integrationsSelectorSearchPlaceholder = _i18n.i18n.translate('xpack.datasetQuality.integrationsSelectorSearchPlaceholder', {
  defaultMessage: 'Filter integrations'
});
const integrationsSelectorNoneAvailable = _i18n.i18n.translate('xpack.datasetQuality.integrationsSelectorNoneAvailable', {
  defaultMessage: 'No integrations available'
});
const integrationsSelectorNoneMatching = _i18n.i18n.translate('xpack.datasetQuality.integrationsSelectorNoneMatching', {
  defaultMessage: 'No integrations found'
});
function IntegrationsSelector({
  isLoading,
  integrations,
  onIntegrationsChange
}) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const closePopover = () => {
    setIsPopoverOpen(false);
  };
  const renderOption = integration => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_common.IntegrationIcon, {
    integration: integration
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, integration.title));
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    "data-test-subj": "datasetQualityIntegrationsSelectableButton",
    iconType: "arrowDown",
    badgeColor: "success",
    onClick: onButtonClick,
    isSelected: isPopoverOpen,
    numFilters: integrations.length,
    hasActiveFilters: !!integrations.find(item => item.checked === 'on'),
    numActiveFilters: integrations.filter(item => item.checked === 'on').length
  }, integrationsSelectorLabel);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "data-test-subj": "datasetQualityIntegrationsSelectable",
    searchable: true,
    searchProps: {
      placeholder: integrationsSelectorSearchPlaceholder,
      compressed: true
    },
    "aria-label": integrationsSelectorLabel,
    options: integrations,
    onChange: onIntegrationsChange,
    isLoading: isLoading,
    loadingMessage: integrationsSelectorLoading,
    emptyMessage: integrationsSelectorNoneAvailable,
    noMatchesMessage: integrationsSelectorNoneMatching,
    renderOption: option => renderOption(option)
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, search), list)));
}