"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShortcutsPopover = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _shortcut_line = require("./shortcut_line");
var _keys = require("./keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ShortcutsPopover = ({
  button,
  isOpen,
  closePopover
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isOpen,
    closePopover: closePopover,
    anchorPosition: "downRight",
    "data-test-subj": "consoleShortcutsPopover"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('console.shortcuts.navigationShortcutsSubtitle', {
    defaultMessage: 'Navigation shortcuts'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_shortcut_line.ShortcutLineFlexItem, {
    id: "goToLineNumber",
    description: "Go to line number",
    keys: [_keys.KEYS.keyCtrlCmd, _keys.KEYS.keyL]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('console.shortcuts.requestShortcutsSubtitle', {
    defaultMessage: 'Request shortcuts'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_shortcut_line.ShortcutLineFlexItem, {
    id: "autoindentCurrentRequest",
    description: "Auto-indent current request",
    keys: [_keys.KEYS.keyCtrlCmd, _keys.KEYS.keyI]
  }), /*#__PURE__*/_react.default.createElement(_shortcut_line.ShortcutLineFlexItem, {
    id: "jumpToNextRequestEnd",
    description: "Jump to next request end",
    keys: [_keys.KEYS.keyCtrlCmd, _keys.KEYS.keyDown]
  }), /*#__PURE__*/_react.default.createElement(_shortcut_line.ShortcutLineFlexItem, {
    id: "jumpToPreviousRequestEnd",
    description: "Jump to previous request end",
    keys: [_keys.KEYS.keyCtrlCmd, _keys.KEYS.keyUp]
  }), /*#__PURE__*/_react.default.createElement(_shortcut_line.ShortcutLineFlexItem, {
    id: "openDocumentation",
    description: "Open documentation for current request",
    keys: [_keys.KEYS.keyCtrlCmd, _keys.KEYS.keySlash]
  }), /*#__PURE__*/_react.default.createElement(_shortcut_line.ShortcutLineFlexItem, {
    id: "runRequest",
    description: "Run current request",
    keys: [_keys.KEYS.keyCtrlCmd, _keys.KEYS.keyEnter]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('console.shortcuts.autocompleteShortcutsSubtitle', {
    defaultMessage: 'Autocomplete menu shortcuts'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_shortcut_line.ShortcutLineFlexItem, {
    id: "applyCurrentAutocompleteSuggestion",
    description: "Apply current or topmost term in menu",
    keys: [_keys.KEYS.keyEnter],
    alternativeKeys: [_keys.KEYS.keyTab]
  }), /*#__PURE__*/_react.default.createElement(_shortcut_line.ShortcutLineFlexItem, {
    id: "closeAutocompleteMenu",
    description: "Close autocomplete menu",
    keys: [_keys.KEYS.keyEsc]
  }), /*#__PURE__*/_react.default.createElement(_shortcut_line.ShortcutLineFlexItem, {
    id: "navigateAutocompleteMenu",
    description: "Navigate items in autocomplete menu",
    keys: [_keys.KEYS.keyDown],
    alternativeKeys: [_keys.KEYS.keyUp]
  })));
};
exports.ShortcutsPopover = ShortcutsPopover;