"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExportApp = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react2 = require("@emotion/react");
var _workpad_page = require("../workpad_page");
var _routing = require("../routing");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error untyped local

const ExportApp = ({
  workpad,
  selectedPageIndex,
  initializeWorkpad
}) => {
  const {
    id,
    pages,
    height,
    width
  } = workpad;
  const activePage = pages[selectedPageIndex];
  const pageElementCount = activePage.elements.length;
  (0, _react.useEffect)(() => initializeWorkpad());
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasExport",
    "data-shared-page": selectedPageIndex + 1
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasExport__stage"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasLayout__stageHeader"
  }, /*#__PURE__*/_react.default.createElement(_routing.RoutingLink, {
    to: `/workpad/${id}`
  }, "Edit Workpad")), /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)(workpad.css),
    className: "canvasExport__stageContent",
    "data-shared-items-count": pageElementCount
  }, /*#__PURE__*/_react.default.createElement(_workpad_page.WorkpadPage, {
    isSelected: true,
    key: activePage.id,
    pageId: activePage.id,
    height: height,
    width: width,
    registerLayout: () => {},
    unregisterLayout: () => {}
  }))));
};
exports.ExportApp = ExportApp;
ExportApp.propTypes = {
  // @ts-expect-error upgrade typescript v5.9.3
  workpad: _propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    pages: _propTypes.default.array.isRequired
  }).isRequired,
  selectedPageIndex: _propTypes.default.number.isRequired,
  initializeWorkpad: _propTypes.default.func.isRequired
};