"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BarDetails = BarDetails;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
var _formatters = require("../../../../common/utils/formatters");
var _truncate_with_tooltip = require("../truncate_with_tooltip");
var _trace_waterfall_context = require("./trace_waterfall_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ORPHAN_TITLE = _i18n.i18n.translate('xpack.apm.trace.barDetails.euiIconTip.orphanTitleLabel', {
  defaultMessage: 'Orphan'
});
const ORPHAN_CONTENT = _i18n.i18n.translate('xpack.apm.trace.barDetails.euiIconTip.orphanSpanContentLabel', {
  defaultMessage: 'This span is orphaned due to missing trace context and has been reparented to the root to restore the execution flow'
});
function BarDetails({
  item,
  left,
  onErrorClick
}) {
  const theme = (0, _eui.useEuiTheme)();
  const {
    getRelatedErrorsHref
  } = (0, _trace_waterfall_context.useTraceWaterfallContext)();
  const viewRelatedErrorsLabel = _i18n.i18n.translate('xpack.apm.waterfall.embeddableRelatedErrors.unifedErrorCount', {
    defaultMessage: 'View related errors'
  });
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
        position: relative;
        height: ${theme.euiTheme.size.l};
      `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    alignItems: "center",
    css: (0, _react.css)`
          min-width: ${Math.max(100 - left, 0)}%;
          position: absolute;
          right: 0;
          max-width: 100%;
          margin-top: ${theme.euiTheme.size.xxs};
          & > div:last-child {
            margin-right: ${theme.euiTheme.size.s};
            white-space: nowrap;
          }
        `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react.css)`
            min-width: 0;
          `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: {
      overflow: 'hidden'
    },
    size: "s"
  }, /*#__PURE__*/_react2.default.createElement(_truncate_with_tooltip.TruncateWithTooltip, {
    content: item.name,
    text: item.name
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, (0, _formatters.asDuration)(item.duration))), item.hasError ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, onErrorClick ? /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.apm.barDetails.errorButton.ariaLabel', {
      defaultMessage: 'View error details'
    }),
    "data-test-subj": "apmBarDetailsButton",
    color: "danger",
    iconType: "errorFilled",
    iconSize: "s",
    href: getRelatedErrorsHref ? getRelatedErrorsHref(item.id) : undefined,
    onClick: e => {
      if (onErrorClick) {
        e.preventDefault();
        e.stopPropagation();
        onErrorClick({
          traceId: item.traceId,
          docId: item.id
        });
      }
    }
  }) : getRelatedErrorsHref ? /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    color: theme.euiTheme.colors.danger,
    iconType: "arrowRight",
    href: getRelatedErrorsHref(item.id),
    onClick: e => {
      e.stopPropagation();
    },
    tabIndex: 0,
    role: "button",
    "aria-label": viewRelatedErrorsLabel,
    onClickAriaLabel: viewRelatedErrorsLabel
  }, viewRelatedErrorsLabel) : /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: "errorFilled",
    color: theme.euiTheme.colors.danger,
    size: "s"
  })) : null, item.isOrphan ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
    "data-test-subj": "apmBarDetailsOrphanTooltip",
    iconProps: {
      'data-test-subj': 'apmBarDetailsOrphanIcon',
      'aria-label': ORPHAN_TITLE
    },
    color: theme.euiTheme.colors.danger,
    type: "unlink",
    title: ORPHAN_TITLE,
    content: ORPHAN_CONTENT
  })) : null));
}