"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomTooltip = CustomTooltip;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _service_nodes = require("../../../../../common/service_nodes");
var _formatters = require("../../../../../common/utils/formatters");
var _use_theme = require("../../../../hooks/use_theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const latencyLabel = _i18n.i18n.translate('xpack.apm.instancesLatencyDistributionChartTooltipLatencyLabel', {
  defaultMessage: 'Latency'
});
const throughputLabel = _i18n.i18n.translate('xpack.apm.instancesLatencyDistributionChartTooltipThroughputLabel', {
  defaultMessage: 'Throughput'
});
const clickToFilterDescription = _i18n.i18n.translate('xpack.apm.instancesLatencyDistributionChartTooltipClickToFilterDescription', {
  defaultMessage: 'Click to filter by instance'
});

/**
 * Tooltip for a single instance
 */
function SingleInstanceCustomTooltip({
  latencyFormatter,
  values
}) {
  const value = values[0];
  const {
    color
  } = value;
  const datum = value.datum;
  const {
    latency,
    serviceNodeName,
    throughput
  } = datum;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "echTooltip__header"
  }, (0, _service_nodes.getServiceNodeName)(serviceNodeName)), /*#__PURE__*/_react.default.createElement("div", {
    className: "echTooltip__list"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "echTooltip__item"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "echTooltip__item--backgroundColor",
    style: {
      backgroundColor: 'transparent'
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "echTooltip__item--color",
    style: {
      backgroundColor: color
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "echTooltip__item--container"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "echTooltip__label"
  }, latencyLabel), /*#__PURE__*/_react.default.createElement("span", {
    className: "echTooltip__value"
  }, latencyFormatter(latency).formatted))), /*#__PURE__*/_react.default.createElement("div", {
    className: "echTooltip__item"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "echTooltip__item--backgroundColor",
    style: {
      backgroundColor: 'transparent'
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "echTooltip__item--color",
    style: {
      backgroundColor: color
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "echTooltip__item--container"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "echTooltip__label"
  }, throughputLabel), /*#__PURE__*/_react.default.createElement("span", {
    className: "echTooltip__value"
  }, (0, _formatters.asTransactionRate)(throughput))))));
}

/**
 * Tooltip for a multiple instances
 */
function MultipleInstanceCustomTooltip({
  latencyFormatter,
  values
}) {
  const theme = (0, _use_theme.useTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "echTooltip__header"
  }, _i18n.i18n.translate('xpack.apm.instancesLatencyDistributionChartTooltipInstancesTitle', {
    defaultMessage: '{instancesCount} {instancesCount, plural, one {instance} other {instances}}',
    values: {
      instancesCount: values.length
    }
  })), values.map(value => {
    const {
      color,
      seriesIdentifier
    } = value;
    const datum = value.datum;
    const {
      latency,
      serviceNodeName,
      throughput
    } = datum;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__list",
      key: seriesIdentifier.key
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__item"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__item--backgroundColor",
      style: {
        backgroundColor: 'transparent'
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__item--color",
      style: {
        backgroundColor: color
      }
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__item--container"
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "echTooltip__label"
    }, (0, _service_nodes.getServiceNodeName)(serviceNodeName)))), /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__item"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__item--backgroundColor",
      style: {
        backgroundColor: 'transparent'
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__item--color",
      style: {
        backgroundColor: color
      }
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__item--container",
      style: {
        paddingLeft: theme.eui.euiSizeS
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "echTooltip__label"
    }, latencyLabel), /*#__PURE__*/_react.default.createElement("span", {
      className: "echTooltip__value"
    }, latencyFormatter(latency).formatted))), /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__item"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__item--backgroundColor",
      style: {
        backgroundColor: 'transparent'
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__item--color",
      style: {
        backgroundColor: color
      }
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__item--container",
      style: {
        paddingLeft: theme.eui.euiSizeS
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "echTooltip__label"
    }, throughputLabel), /*#__PURE__*/_react.default.createElement("span", {
      className: "echTooltip__value"
    }, (0, _formatters.asTransactionRate)(throughput)))));
  }));
}

/**
 * Custom tooltip for instances latency distribution chart.
 *
 * The styling provided here recreates that in the Elastic Charts tooltip: https://github.com/elastic/elastic-charts/blob/58e6b5fbf77f4471d2a9a41c45a61f79ebd89b65/src/components/tooltip/tooltip.tsx
 *
 * We probably won't need to do all of this once https://github.com/elastic/elastic-charts/issues/615 is completed.
 */
function CustomTooltip(props) {
  const {
    values
  } = props;
  const theme = (0, _use_theme.useTheme)();
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "echTooltip"
  }, values.length > 1 ? /*#__PURE__*/_react.default.createElement(MultipleInstanceCustomTooltip, props) : /*#__PURE__*/_react.default.createElement(SingleInstanceCustomTooltip, props), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      padding: theme.eui.euiSizeXS
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "filter"
  }), " ", clickToFilterDescription));
}