"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.batchBackfillRuleGaps = void 0;
var _types = require("./types");
var _process_all_rule_gaps = require("../../../../lib/rule_gaps/process_all_rule_gaps");
var _utils = require("./utils");
var _process_gaps_batch = require("./process_gaps_batch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const batchBackfillRuleGaps = async (context, {
  rule,
  range,
  maxGapCountPerRule
}) => {
  const logger = context.logger.get('gaps');
  const {
    start,
    end
  } = range;
  let resultError;
  let hasBeenBackfilled = false;
  const eventLogClient = await context.getEventLogClient();
  try {
    const processingResults = await (0, _process_all_rule_gaps.processAllRuleGaps)({
      ruleId: rule.id,
      start,
      end,
      eventLogClient,
      logger,
      processGapsBatch: gapsBatch => (0, _process_gaps_batch.processGapsBatch)(context, {
        rule,
        range,
        gapsBatch
      }),
      options: {
        maxFetchedGaps: maxGapCountPerRule
      }
    });
    hasBeenBackfilled = processingResults.some(result => result);
  } catch (error) {
    (0, _utils.logProcessedAsAuditEvent)(context, rule, error);
    resultError = (0, _utils.toBulkGapFillError)(rule, _types.BulkGapsFillStep.SCHEDULING, error);
  }
  if (!resultError && !hasBeenBackfilled) {
    return {
      outcome: _types.BulkFillGapsScheduleResult.SKIPPED
    };
  }
  if (resultError) {
    return {
      outcome: _types.BulkFillGapsScheduleResult.ERRORED,
      error: resultError
    };
  }
  return {
    outcome: _types.BulkFillGapsScheduleResult.BACKFILLED
  };
};
exports.batchBackfillRuleGaps = batchBackfillRuleGaps;