/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RotationShardShuffler;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.ShardShuffler;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.ExponentiallyWeightedMovingAverage;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.node.ResponseCollectorService;

public class IndexShardRoutingTable {
    final ShardShuffler shuffler = new RotationShardShuffler(Randomness.get().nextInt());
    final ShardId shardId;
    final ShardRouting[] shards;
    final ShardRouting primary;
    final List<ShardRouting> replicas;
    final List<ShardRouting> activeShards;
    final List<ShardRouting> assignedShards;
    private final List<ShardRouting> unpromotableShards;
    final List<ShardRouting> allInitializingShards;
    final boolean allShardsStarted;
    final int activeSearchShardCount;
    final int totalSearchShardCount;

    IndexShardRoutingTable(ShardId shardId, List<ShardRouting> shards) {
        this.shardId = shardId;
        this.shards = (ShardRouting[])shards.toArray(ShardRouting[]::new);
        ShardRouting primary = null;
        ArrayList<ShardRouting> replicas = new ArrayList<ShardRouting>();
        ArrayList<ShardRouting> activeShards = new ArrayList<ShardRouting>();
        ArrayList<ShardRouting> assignedShards = new ArrayList<ShardRouting>();
        ArrayList<ShardRouting> unpromotableShards = new ArrayList<ShardRouting>();
        ArrayList<ShardRouting> allInitializingShards = new ArrayList<ShardRouting>();
        boolean allShardsStarted = true;
        int activeSearchShardCount = 0;
        int totalSearchShardCount = 0;
        for (ShardRouting shard : this.shards) {
            if (shard.primary()) {
                assert (primary == null) : "duplicate primary: " + String.valueOf(primary) + " vs " + String.valueOf(shard);
                primary = shard;
            } else {
                replicas.add(shard);
            }
            if (shard.active()) {
                activeShards.add(shard);
                if (shard.role().isSearchable()) {
                    ++activeSearchShardCount;
                }
            }
            if (shard.role().isSearchable()) {
                ++totalSearchShardCount;
            }
            if (shard.initializing()) {
                allInitializingShards.add(shard);
            }
            if (shard.relocating()) {
                allInitializingShards.add(shard.getTargetRelocatingShard());
                assert (shard.assignedToNode()) : "relocating from unassigned " + String.valueOf(shard);
                assert (shard.getTargetRelocatingShard().assignedToNode()) : "relocating to unassigned " + String.valueOf(shard.getTargetRelocatingShard());
                assignedShards.add(shard.getTargetRelocatingShard());
                if (!shard.getTargetRelocatingShard().isPromotableToPrimary()) {
                    unpromotableShards.add(shard.getTargetRelocatingShard());
                }
            }
            if (shard.assignedToNode()) {
                assignedShards.add(shard);
                if (!shard.isPromotableToPrimary()) {
                    unpromotableShards.add(shard);
                }
            }
            if (shard.state() == ShardRoutingState.STARTED) continue;
            allShardsStarted = false;
        }
        assert (!shards.isEmpty()) : "cannot have an empty shard routing table";
        assert (primary != null) : shards;
        this.primary = primary;
        this.replicas = CollectionUtils.wrapUnmodifiableOrEmptySingleton(replicas);
        this.activeShards = CollectionUtils.wrapUnmodifiableOrEmptySingleton(activeShards);
        this.assignedShards = CollectionUtils.wrapUnmodifiableOrEmptySingleton(assignedShards);
        this.unpromotableShards = CollectionUtils.wrapUnmodifiableOrEmptySingleton(unpromotableShards);
        this.allInitializingShards = CollectionUtils.wrapUnmodifiableOrEmptySingleton(allInitializingShards);
        this.allShardsStarted = allShardsStarted;
        this.activeSearchShardCount = activeSearchShardCount;
        this.totalSearchShardCount = totalSearchShardCount;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public int size() {
        return this.shards.length;
    }

    public ShardRouting shard(int idx) {
        return this.shards[idx];
    }

    public Stream<ShardRouting> allShards() {
        return Stream.of(this.shards);
    }

    public List<ShardRouting> activeShards() {
        return this.activeShards;
    }

    public List<ShardRouting> getAllInitializingShards() {
        return this.allInitializingShards;
    }

    public List<ShardRouting> assignedShards() {
        return this.assignedShards;
    }

    public List<ShardRouting> unpromotableShards() {
        return this.unpromotableShards;
    }

    public ShardIterator shardsRandomIt() {
        return new ShardIterator(this.shardId, this.shuffler.shuffle(Arrays.asList(this.shards)));
    }

    public ShardIterator shardsIt(int seed) {
        return new ShardIterator(this.shardId, this.shuffler.shuffle(Arrays.asList(this.shards), seed));
    }

    public ShardIterator activeInitializingShardsRandomIt() {
        return this.activeInitializingShardsIt(this.shuffler.nextSeed());
    }

    public ShardIterator activeInitializingShardsIt(int seed) {
        if (this.allInitializingShards.isEmpty()) {
            return new ShardIterator(this.shardId, this.shuffler.shuffle(this.activeShards, seed));
        }
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        ordered.addAll(this.shuffler.shuffle(this.activeShards, seed));
        ordered.addAll(this.allInitializingShards);
        return new ShardIterator(this.shardId, ordered);
    }

    public ShardIterator activeInitializingShardsRankedIt(@Nullable ResponseCollectorService collector, @Nullable Map<String, Long> nodeSearchCounts) {
        int seed = this.shuffler.nextSeed();
        if (this.allInitializingShards.isEmpty()) {
            return new ShardIterator(this.shardId, IndexShardRoutingTable.rankShardsAndUpdateStats(this.shuffler.shuffle(this.activeShards, seed), collector, nodeSearchCounts));
        }
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        List<ShardRouting> rankedActiveShards = IndexShardRoutingTable.rankShardsAndUpdateStats(this.shuffler.shuffle(this.activeShards, seed), collector, nodeSearchCounts);
        ordered.addAll(rankedActiveShards);
        List<ShardRouting> rankedInitializingShards = IndexShardRoutingTable.rankShardsAndUpdateStats(this.allInitializingShards, collector, nodeSearchCounts);
        ordered.addAll(rankedInitializingShards);
        return new ShardIterator(this.shardId, ordered);
    }

    private static Set<String> getAllNodeIds(List<ShardRouting> shards) {
        HashSet<String> nodeIds = new HashSet<String>();
        for (ShardRouting shard : shards) {
            nodeIds.add(shard.currentNodeId());
        }
        return nodeIds;
    }

    private static Map<String, Optional<ResponseCollectorService.ComputedNodeStats>> getNodeStats(Set<String> nodeIds, ResponseCollectorService collector) {
        Map<String, Optional<ResponseCollectorService.ComputedNodeStats>> nodeStats = Maps.newMapWithExpectedSize(nodeIds.size());
        for (String nodeId : nodeIds) {
            nodeStats.put(nodeId, collector.getNodeStatistics(nodeId));
        }
        return nodeStats;
    }

    private static Map<String, Double> rankNodes(Map<String, Optional<ResponseCollectorService.ComputedNodeStats>> nodeStats, Map<String, Long> nodeSearchCounts) {
        Map<String, Double> nodeRanks = Maps.newMapWithExpectedSize(nodeStats.size());
        for (Map.Entry<String, Optional<ResponseCollectorService.ComputedNodeStats>> entry : nodeStats.entrySet()) {
            Optional<ResponseCollectorService.ComputedNodeStats> maybeStats = entry.getValue();
            maybeStats.ifPresent(stats -> {
                String nodeId = (String)entry.getKey();
                nodeRanks.put(nodeId, stats.rank(nodeSearchCounts.getOrDefault(nodeId, 0L)));
            });
        }
        return nodeRanks;
    }

    private static void adjustStats(ResponseCollectorService collector, Map<String, Optional<ResponseCollectorService.ComputedNodeStats>> nodeStats, String minNodeId, ResponseCollectorService.ComputedNodeStats minStats) {
        if (minNodeId != null) {
            for (Map.Entry<String, Optional<ResponseCollectorService.ComputedNodeStats>> entry : nodeStats.entrySet()) {
                String nodeId = entry.getKey();
                Optional<ResponseCollectorService.ComputedNodeStats> maybeStats = entry.getValue();
                if (nodeId.equals(minNodeId) || !maybeStats.isPresent()) continue;
                ResponseCollectorService.ComputedNodeStats stats = maybeStats.get();
                int updatedQueue = (minStats.queueSize + stats.queueSize) / 2;
                long updatedResponse = (long)(minStats.responseTime + stats.responseTime) / 2L;
                ExponentiallyWeightedMovingAverage avgServiceTime = new ExponentiallyWeightedMovingAverage(0.3, stats.serviceTime);
                avgServiceTime.addValue((minStats.serviceTime + stats.serviceTime) / 2.0);
                long updatedService = (long)avgServiceTime.getAverage();
                collector.addNodeStatistics(nodeId, updatedQueue, updatedResponse, updatedService);
            }
        }
    }

    private static List<ShardRouting> rankShardsAndUpdateStats(List<ShardRouting> shards, ResponseCollectorService collector, Map<String, Long> nodeSearchCounts) {
        String minNodeId;
        Optional<ResponseCollectorService.ComputedNodeStats> maybeMinStats;
        ShardRouting minShard;
        if (collector == null || nodeSearchCounts == null || shards.size() <= 1) {
            return shards;
        }
        Set<String> nodeIds = IndexShardRoutingTable.getAllNodeIds(shards);
        Map<String, Optional<ResponseCollectorService.ComputedNodeStats>> nodeStats = IndexShardRoutingTable.getNodeStats(nodeIds, collector);
        Map<String, Double> nodeRanks = IndexShardRoutingTable.rankNodes(nodeStats, nodeSearchCounts);
        ArrayList<ShardRouting> sortedShards = new ArrayList<ShardRouting>(shards);
        Collections.sort(sortedShards, new NodeRankComparator(nodeRanks));
        if (sortedShards.size() > 1 && (minShard = sortedShards.get(0)).started() && (maybeMinStats = nodeStats.get(minNodeId = minShard.currentNodeId())).isPresent()) {
            IndexShardRoutingTable.adjustStats(collector, nodeStats, minNodeId, maybeMinStats.get());
            nodeSearchCounts.compute(minNodeId, (id, conns) -> conns == null ? 1L : conns + 1L);
        }
        return sortedShards;
    }

    public ShardIterator primaryShardIt() {
        if (this.primary != null) {
            return new ShardIterator(this.shardId, Collections.singletonList(this.primary));
        }
        return new ShardIterator(this.shardId, Collections.emptyList());
    }

    public ShardIterator onlyNodeActiveInitializingShardsIt(String nodeId) {
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        int seed = this.shuffler.nextSeed();
        for (ShardRouting shardRouting : this.shuffler.shuffle(this.activeShards, seed)) {
            if (!nodeId.equals(shardRouting.currentNodeId())) continue;
            ordered.add(shardRouting);
        }
        for (ShardRouting shardRouting : this.shuffler.shuffle(this.allInitializingShards, seed)) {
            if (!nodeId.equals(shardRouting.currentNodeId())) continue;
            ordered.add(shardRouting);
        }
        return new ShardIterator(this.shardId, ordered);
    }

    public ShardIterator onlyNodeSelectorActiveInitializingShardsIt(String nodeAttributes, DiscoveryNodes discoveryNodes) {
        return this.onlyNodeSelectorActiveInitializingShardsIt(new String[]{nodeAttributes}, discoveryNodes);
    }

    public ShardIterator onlyNodeSelectorActiveInitializingShardsIt(String[] nodeAttributes, DiscoveryNodes discoveryNodes) {
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        HashSet<String> selectedNodes = Sets.newHashSet(discoveryNodes.resolveNodes(nodeAttributes));
        int seed = this.shuffler.nextSeed();
        for (ShardRouting shardRouting : this.shuffler.shuffle(this.activeShards, seed)) {
            if (!selectedNodes.contains(shardRouting.currentNodeId())) continue;
            ordered.add(shardRouting);
        }
        for (ShardRouting shardRouting : this.shuffler.shuffle(this.allInitializingShards, seed)) {
            if (!selectedNodes.contains(shardRouting.currentNodeId())) continue;
            ordered.add(shardRouting);
        }
        if (ordered.isEmpty()) {
            String message = String.format(Locale.ROOT, "no data nodes with %s [%s] found for shard: %s", nodeAttributes.length == 1 ? "criteria" : "criterion", String.join((CharSequence)",", nodeAttributes), this.shardId());
            throw new IllegalArgumentException(message);
        }
        return new ShardIterator(this.shardId, ordered);
    }

    public ShardIterator preferNodeActiveInitializingShardsIt(Set<String> nodeIds) {
        ArrayList<ShardRouting> preferred = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        ArrayList<ShardRouting> notPreferred = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        for (ShardRouting shardRouting : this.shuffler.shuffle(this.activeShards)) {
            if (nodeIds.contains(shardRouting.currentNodeId())) {
                preferred.add(shardRouting);
                continue;
            }
            notPreferred.add(shardRouting);
        }
        preferred.addAll(notPreferred);
        if (!this.allInitializingShards.isEmpty()) {
            preferred.addAll(this.allInitializingShards);
        }
        return new ShardIterator(this.shardId, preferred);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexShardRoutingTable that = (IndexShardRoutingTable)o;
        if (!this.shardId.equals(that.shardId)) {
            return false;
        }
        return Arrays.equals(this.shards, that.shards);
    }

    public int hashCode() {
        int result = this.shardId.hashCode();
        result = 31 * result + Arrays.hashCode(this.shards);
        return result;
    }

    public boolean allShardsStarted() {
        return this.allShardsStarted;
    }

    public int getActiveSearchShardCount() {
        return this.activeSearchShardCount;
    }

    public int getTotalSearchShardCount() {
        return this.totalSearchShardCount;
    }

    public boolean hasSearchShards() {
        return this.totalSearchShardCount > 0;
    }

    @Nullable
    public ShardRouting getByAllocationId(String allocationId) {
        for (ShardRouting shardRouting : this.assignedShards()) {
            if (!shardRouting.allocationId().getId().equals(allocationId)) continue;
            return shardRouting;
        }
        return null;
    }

    public Set<String> getPromotableAllocationIds() {
        assert (MasterService.assertNotMasterUpdateThread("not using this on the master thread so we don't have to pre-compute this"));
        HashSet<String> allAllocationIds = new HashSet<String>();
        for (ShardRouting shard : this.shards) {
            if (!shard.isPromotableToPrimary()) continue;
            if (shard.relocating()) {
                allAllocationIds.add(shard.getTargetRelocatingShard().allocationId().getId());
            }
            if (!shard.assignedToNode()) continue;
            allAllocationIds.add(shard.allocationId().getId());
        }
        return allAllocationIds;
    }

    public ShardRouting primaryShard() {
        return this.primary;
    }

    public List<ShardRouting> replicaShards() {
        return this.replicas;
    }

    public List<ShardRouting> replicaShardsWithState(ShardRoutingState ... states) {
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (ShardRouting shardEntry : this.replicas) {
            for (ShardRoutingState state : states) {
                if (shardEntry.state() != state) continue;
                shards.add(shardEntry);
            }
        }
        return shards;
    }

    public List<ShardRouting> shardsWithState(ShardRoutingState state) {
        if (state == ShardRoutingState.INITIALIZING) {
            return this.allInitializingShards;
        }
        ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
        for (ShardRouting shardEntry : this.shards) {
            if (shardEntry.state() != state) continue;
            shards.add(shardEntry);
        }
        return shards;
    }

    public static Builder builder(ShardId shardId) {
        return new Builder(shardId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IndexShardRoutingTable(").append(this.shardId()).append("){");
        int numShards = this.shards.length;
        for (int i = 0; i < numShards; ++i) {
            sb.append(this.shards[i].shortSummary());
            if (i >= numShards - 1) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    private static class NodeRankComparator
    implements Comparator<ShardRouting> {
        private final Map<String, Double> nodeRanks;

        NodeRankComparator(Map<String, Double> nodeRanks) {
            this.nodeRanks = nodeRanks;
        }

        @Override
        public int compare(ShardRouting s1, ShardRouting s2) {
            if (s1.currentNodeId().equals(s2.currentNodeId())) {
                return 0;
            }
            Double shard1rank = this.nodeRanks.get(s1.currentNodeId());
            Double shard2rank = this.nodeRanks.get(s2.currentNodeId());
            if (shard1rank != null) {
                if (shard2rank != null) {
                    return shard1rank.compareTo(shard2rank);
                }
                return 1;
            }
            if (shard2rank != null) {
                return -1;
            }
            return 0;
        }
    }

    public static class Builder {
        private final ShardId shardId;
        private final List<ShardRouting> shards;

        public Builder(IndexShardRoutingTable indexShard) {
            this.shardId = indexShard.shardId;
            this.shards = new ArrayList<ShardRouting>(indexShard.size());
            Collections.addAll(this.shards, indexShard.shards);
        }

        public ShardId shardId() {
            return this.shardId;
        }

        public Builder(ShardId shardId) {
            this.shardId = shardId;
            this.shards = new ArrayList<ShardRouting>();
        }

        public Builder addShard(ShardRouting shardEntry) {
            assert (shardEntry.shardId().equals(this.shardId)) : "cannot add [" + String.valueOf(shardEntry) + "] to routing table for " + String.valueOf(this.shardId);
            this.shards.add(shardEntry);
            return this;
        }

        public Builder removeShard(ShardRouting shardEntry) {
            this.shards.remove(shardEntry);
            return this;
        }

        public IndexShardRoutingTable build() {
            assert (Builder.distinctNodes(this.shards)) : "more than one shard with same id assigned to same node (shards: " + String.valueOf(this.shards) + ")";
            assert (Builder.noDuplicatePrimary(this.shards)) : "expected but did not find unique primary in shard routing table: " + String.valueOf(this.shards);
            assert (Builder.noAssignedReplicaWithoutActivePrimary(this.shards)) : "unexpected assigned replica with no active primary: " + String.valueOf(this.shards);
            return new IndexShardRoutingTable(this.shardId, this.shards);
        }

        static boolean distinctNodes(List<ShardRouting> shards) {
            HashSet<String> nodes = new HashSet<String>();
            for (ShardRouting shard : shards) {
                if (!shard.assignedToNode()) continue;
                if (!nodes.add(shard.currentNodeId())) {
                    return false;
                }
                if (!shard.relocating() || nodes.add(shard.relocatingNodeId())) continue;
                return false;
            }
            return true;
        }

        static boolean noDuplicatePrimary(List<ShardRouting> shards) {
            boolean seenPrimary = false;
            for (ShardRouting shard : shards) {
                if (!shard.primary()) continue;
                if (seenPrimary) {
                    return false;
                }
                seenPrimary = true;
            }
            return seenPrimary;
        }

        static boolean noAssignedReplicaWithoutActivePrimary(List<ShardRouting> shards) {
            boolean seenAssignedReplica = false;
            for (ShardRouting shard : shards) {
                if (shard.currentNodeId() == null) continue;
                if (shard.primary()) {
                    if (!shard.active()) continue;
                    return true;
                }
                seenAssignedReplica = true;
            }
            return !seenAssignedReplica;
        }

        public static Builder readFrom(StreamInput in) throws IOException {
            Index index = new Index(in);
            return Builder.readFromThin(in, index);
        }

        public static Builder readFromThin(StreamInput in, Index index) throws IOException {
            int iShardId = in.readVInt();
            ShardId shardId = new ShardId(index, iShardId);
            Builder builder = new Builder(shardId);
            int size = in.readVInt();
            for (int i = 0; i < size; ++i) {
                ShardRouting shard = new ShardRouting(shardId, in);
                builder.addShard(shard);
            }
            return builder;
        }

        public static void writeTo(IndexShardRoutingTable indexShard, StreamOutput out) throws IOException {
            indexShard.shardId().getIndex().writeTo(out);
            Builder.writeToThin(indexShard, out);
        }

        public static void writeToThin(IndexShardRoutingTable indexShard, StreamOutput out) throws IOException {
            out.writeVInt(indexShard.shardId.id());
            out.writeArray((o, v) -> v.writeToThin(o), indexShard.shards);
        }
    }

    record AttributesKey(List<String> attributes) {
    }
}

