/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class NodesInfoMetrics
implements Writeable {
    private final Set<String> requestedMetrics;

    public NodesInfoMetrics() {
        this.requestedMetrics = new HashSet<String>(Metric.allMetrics());
    }

    public NodesInfoMetrics(StreamInput in) throws IOException {
        this.requestedMetrics = in.readCollectionAsImmutableSet(StreamInput::readString);
    }

    public Set<String> requestedMetrics() {
        return this.requestedMetrics;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.requestedMetrics);
    }

    public static enum Metric {
        SETTINGS("settings"),
        OS("os"),
        PROCESS("process"),
        JVM("jvm"),
        THREAD_POOL("thread_pool"),
        TRANSPORT("transport"),
        HTTP("http"),
        REMOTE_CLUSTER_SERVER("remote_cluster_server"),
        PLUGINS("plugins"),
        INGEST("ingest"),
        AGGREGATIONS("aggregations"),
        INDICES("indices");

        private static final Set<String> ALL_METRICS;
        private final String metricName;

        private Metric(String name) {
            this.metricName = name;
        }

        public String metricName() {
            return this.metricName;
        }

        public static Set<String> allMetrics() {
            return ALL_METRICS;
        }

        static {
            ALL_METRICS = Arrays.stream(Metric.values()).map(Metric::metricName).collect(Collectors.toUnmodifiableSet());
        }
    }
}

