/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.TrimFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.NormalizingTokenFilterFactory;

public class TrimTokenFilterFactory
extends AbstractTokenFilterFactory
implements NormalizingTokenFilterFactory {
    private static final String UPDATE_OFFSETS_KEY = "update_offsets";

    TrimTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(name, settings);
        if (settings.get(UPDATE_OFFSETS_KEY) != null) {
            throw new IllegalArgumentException("update_offsets is not supported anymore. Please fix your analysis chain");
        }
    }

    public TokenStream create(TokenStream tokenStream) {
        return new TrimFilter(tokenStream);
    }
}

