/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.session;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;

public interface RowView
extends Iterable<Object> {
    public int columnCount();

    public Object column(int var1);

    default public <T> T column(int index, Class<T> type) {
        return type.cast(this.column(index));
    }

    @Override
    default public void forEach(Consumer<? super Object> action) {
        this.forEachColumn(action);
    }

    default public void forEachColumn(Consumer<? super Object> action) {
        Objects.requireNonNull(action);
        int rowSize = this.columnCount();
        for (int i = 0; i < rowSize; ++i) {
            action.accept(this.column(i));
        }
    }

    @Override
    default public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            private int pos = 0;
            private final int rowSize = RowView.this.columnCount();

            @Override
            public boolean hasNext() {
                return this.pos < this.rowSize;
            }

            @Override
            public Object next() {
                if (this.pos >= this.rowSize) {
                    throw new NoSuchElementException();
                }
                return RowView.this.column(this.pos++);
            }
        };
    }
}

