/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.store;

import com.microsoft.kiota.TriConsumer;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryBackingStore
implements BackingStore {
    private boolean isInitializationCompleted = true;
    private boolean returnOnlyChangedValues;
    private final Map<String, Pair<Boolean, Object>> store = new ConcurrentHashMap<String, Pair<Boolean, Object>>();
    private final Map<String, TriConsumer<String, Object, Object>> subscriptionStore = new ConcurrentHashMap<String, TriConsumer<String, Object, Object>>();

    @Override
    public void setIsInitializationCompleted(boolean value) {
        this.isInitializationCompleted = value;
        this.ensureCollectionPropertiesAreConsistent();
        for (Map.Entry<String, Pair<Boolean, Object>> entry : this.store.entrySet()) {
            Pair<Boolean, Object> wrapper = entry.getValue();
            Pair<Boolean, Object> updatedValue = new Pair<Boolean, Object>(!value, wrapper.getValue1());
            entry.setValue(updatedValue);
            if (wrapper.getValue1() instanceof BackedModel) {
                BackedModel backedModel = (BackedModel)wrapper.getValue1();
                backedModel.getBackingStore().setIsInitializationCompleted(value);
            }
            if (!this.isCollectionValue(wrapper)) continue;
            Pair collectionTuple = (Pair)wrapper.getValue1();
            Object[] items = this.getObjectArrayFromCollectionWrapper(collectionTuple);
            boolean isCollection = collectionTuple.getValue0() instanceof Collection;
            if ((!isCollection || items.length == 0 || !(items[0] instanceof BackedModel)) && isCollection) continue;
            for (Object item : items) {
                if (!(item instanceof BackedModel)) continue;
                BackedModel backedModel = (BackedModel)item;
                backedModel.getBackingStore().setIsInitializationCompleted(value);
            }
        }
    }

    @Override
    public boolean getIsInitializationCompleted() {
        return this.isInitializationCompleted;
    }

    @Override
    public void setReturnOnlyChangedValues(boolean value) {
        this.returnOnlyChangedValues = value;
        for (Map.Entry<String, Pair<Boolean, Object>> entry : this.store.entrySet()) {
            Pair<Boolean, Object> wrapper = entry.getValue();
            if (wrapper.getValue1() instanceof BackedModel) {
                BackedModel item = (BackedModel)wrapper.getValue1();
                item.getBackingStore().setReturnOnlyChangedValues(value);
            }
            if (!this.isCollectionValue(wrapper)) continue;
            Pair collectionTuple = (Pair)wrapper.getValue1();
            Object[] items = this.getObjectArrayFromCollectionWrapper(collectionTuple);
            boolean isCollection = collectionTuple.getValue0() instanceof Collection;
            if ((!isCollection || items.length == 0 || !(items[0] instanceof BackedModel)) && isCollection) continue;
            for (Object item : items) {
                if (!(item instanceof BackedModel)) continue;
                BackedModel backedModel = (BackedModel)item;
                backedModel.getBackingStore().setReturnOnlyChangedValues(value);
            }
        }
    }

    @Override
    public boolean getReturnOnlyChangedValues() {
        return this.returnOnlyChangedValues;
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    @Override
    @Nonnull
    public Map<String, Object> enumerate() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Pair<Boolean, Object>> entry : this.store.entrySet()) {
            Pair<Boolean, Object> wrapper = entry.getValue();
            Object value = this.get(entry.getKey());
            if (value != null) {
                result.put(entry.getKey(), value);
                continue;
            }
            if (!Boolean.TRUE.equals(wrapper.getValue0())) continue;
            result.put(entry.getKey(), null);
        }
        return result;
    }

    @Override
    @Nonnull
    public Iterable<String> enumerateKeysForValuesChangedToNull() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, Pair<Boolean, Object>> entry : this.store.entrySet()) {
            Pair<Boolean, Object> wrapper = entry.getValue();
            Object value = wrapper.getValue1();
            if (value != null || !wrapper.getValue0().booleanValue()) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private Object getValueFromWrapper(Pair<Boolean, Object> wrapper) {
        if (wrapper == null) {
            return null;
        }
        if (this.isCollectionValue(wrapper)) {
            Pair collectionTuple = (Pair)wrapper.getValue1();
            return collectionTuple.getValue0();
        }
        return wrapper.getValue1();
    }

    @Override
    @Nullable
    public <T> T get(@Nonnull String key) {
        Objects.requireNonNull(key);
        Pair<Boolean, Object> wrapper = this.store.get(key);
        if (wrapper == null) {
            return null;
        }
        Object value = this.getValueFromWrapper(wrapper);
        boolean hasChanged = wrapper.getValue0();
        if (this.getReturnOnlyChangedValues() && !hasChanged) {
            if (this.isCollectionValue(wrapper)) {
                this.ensureCollectionPropertiesAreConsistent();
                hasChanged = this.store.get(key).getValue0();
            }
            if (!hasChanged) {
                return null;
            }
        }
        try {
            return (T)value;
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    @Override
    public <T> void set(@Nonnull String key, @Nullable T value) {
        Object items;
        Objects.requireNonNull(key);
        Pair<Boolean, Object> valueToAdd = new Pair<Boolean, T>(this.isInitializationCompleted, value);
        if (value instanceof Collection) {
            valueToAdd = valueToAdd.setValue1(new Pair<T, Integer>(value, ((Collection)value).size()));
            items = (Collection)value;
            this.setupNestedSubscriptions((Collection<Object>)items, key, value);
        } else if (value instanceof Map) {
            valueToAdd = valueToAdd.setValue1(new Pair<T, Integer>(value, ((Map)value).size()));
            items = (Map)value;
            this.setupNestedSubscriptions(items.values(), key, value);
        } else if (value instanceof BackedModel) {
            BackedModel backedModel = (BackedModel)value;
            backedModel.getBackingStore().subscribe(key, (keyString, oldObject, newObject) -> {
                backedModel.getBackingStore().setIsInitializationCompleted(false);
                this.set(key, value);
            });
        }
        Pair<Boolean, T> oldValue = this.store.put(key, valueToAdd);
        for (TriConsumer<String, Object, Object> callback : this.subscriptionStore.values()) {
            if (oldValue != null) {
                callback.accept(key, oldValue.getValue1(), value);
                continue;
            }
            callback.accept(key, null, value);
        }
    }

    @Override
    public void unsubscribe(@Nonnull String subscriptionId) {
        Objects.requireNonNull(subscriptionId);
        this.subscriptionStore.remove(subscriptionId);
    }

    @Override
    @Nonnull
    public String subscribe(@Nonnull TriConsumer<String, Object, Object> callback) {
        String subscriptionId = UUID.randomUUID().toString();
        this.subscribe(subscriptionId, callback);
        return subscriptionId;
    }

    @Override
    public void subscribe(@Nonnull String subscriptionId, @Nonnull TriConsumer<String, Object, Object> callback) {
        Objects.requireNonNull(callback);
        Objects.requireNonNull(subscriptionId);
        this.subscriptionStore.put(subscriptionId, callback);
    }

    private void setupNestedSubscriptions(Collection<Object> items, String key, Object value) {
        for (Object item : items) {
            if (!(item instanceof BackedModel)) continue;
            BackedModel backedModel = (BackedModel)item;
            backedModel.getBackingStore().setIsInitializationCompleted(false);
            backedModel.getBackingStore().subscribe(key, (keyString, oldObject, newObject) -> this.set(key, value));
        }
    }

    private void ensureCollectionPropertiesAreConsistent() {
        HashMap currentStoreDirtyCollections = new HashMap();
        ArrayList<BackedModel> nestedBackedModelsToEnumerate = new ArrayList<BackedModel>();
        for (Map.Entry<String, Pair<Boolean, Object>> entry : this.store.entrySet()) {
            Pair<Boolean, Object> wrapper = entry.getValue();
            if (!this.isCollectionValue(wrapper)) continue;
            Pair collectionTuple = (Pair)wrapper.getValue1();
            Object[] items = this.getObjectArrayFromCollectionWrapper(collectionTuple);
            boolean isCollection = collectionTuple.getValue0() instanceof Collection;
            if (isCollection && items.length != 0 && items[0] instanceof BackedModel || !isCollection) {
                for (Object item : items) {
                    if (!(item instanceof BackedModel)) continue;
                    BackedModel backedModel = (BackedModel)item;
                    nestedBackedModelsToEnumerate.add(backedModel);
                }
            }
            if ((Integer)collectionTuple.getValue1() == items.length) continue;
            currentStoreDirtyCollections.put(entry.getKey(), collectionTuple.getValue0());
        }
        for (BackedModel backedModel : nestedBackedModelsToEnumerate) {
            backedModel.getBackingStore().enumerate();
        }
        for (Map.Entry<String, Pair<Boolean, Object>> entry : currentStoreDirtyCollections.entrySet()) {
            if (nestedBackedModelsToEnumerate.isEmpty()) {
                this.set(entry.getKey(), entry.getValue());
                continue;
            }
            boolean hasChanged = this.store.get(entry.getKey()).getValue0();
            if (hasChanged) continue;
            this.set(entry.getKey(), entry.getValue());
        }
    }

    private Object[] getObjectArrayFromCollectionWrapper(Pair<?, Integer> collectionTuple) {
        if (collectionTuple == null) {
            throw new IllegalArgumentException("collectionTuple cannot be null");
        }
        if (collectionTuple.getValue0() instanceof Collection) {
            Collection items = (Collection)collectionTuple.getValue0();
            return items.toArray();
        }
        if (collectionTuple.getValue0() instanceof Map) {
            Map items = (Map)collectionTuple.getValue0();
            return items.values().toArray();
        }
        throw new IllegalArgumentException("collectionTuple must be a Collection or a Map");
    }

    private boolean isCollectionValue(Pair<Boolean, Object> wrapper) {
        return wrapper.getValue1() instanceof Pair;
    }

    private static class Pair<A, B> {
        private final A value0;
        private final B value1;

        public Pair(A value0, B value1) {
            this.value0 = value0;
            this.value1 = value1;
        }

        public A getValue0() {
            return this.value0;
        }

        public Pair<A, B> setValue0(A value0) {
            return new Pair<A, B>(value0, this.value1);
        }

        public B getValue1() {
            return this.value1;
        }

        public Pair<A, B> setValue1(B value1) {
            return new Pair<A, B>(this.value0, value1);
        }
    }
}

